/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.parts;

import java.net.URL;
import javax.annotation.PostConstruct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WelcomePart {
    private static final Logger Logger = LoggerFactory.getLogger(WelcomePart.class);
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private static final String APOGY_LOGO_PATH = "/icons/apogy_logo.png";

    @PostConstruct
    public void createControls(Composite parent) {
        GridLayout gl_parent = new GridLayout(1, true);
        gl_parent.verticalSpacing = 10;
        parent.setLayout((Layout)gl_parent);
        Section sctnNewSectionOverview = this.formToolkit.createSection(parent, 256);
        GridData gd_sctnNewSectionDescription = new GridData(4, 4, true, false, 2, 1);
        gd_sctnNewSectionDescription.widthHint = 278;
        sctnNewSectionOverview.setLayoutData((Object)gd_sctnNewSectionDescription);
        this.formToolkit.paintBordersFor((Composite)sctnNewSectionOverview);
        sctnNewSectionOverview.setText("Apogy");
        Composite compositeOverview = this.formToolkit.createComposite((Composite)sctnNewSectionOverview, 0);
        this.formToolkit.paintBordersFor(compositeOverview);
        sctnNewSectionOverview.setClient((Control)compositeOverview);
        compositeOverview.setLayout((Layout)new GridLayout(2, false));
        Bundle bundle = Platform.getBundle((String)"org.eclipse.apogy.workspace.ui");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)bundle.getEntry(APOGY_LOGO_PATH));
        Label label = new Label(compositeOverview, 0);
        label.setImage(imageDescriptor.createImage());
        FormText formText = this.formToolkit.createFormText(compositeOverview, false);
        GridData gd_formText = new GridData(4, 0x1000000, true, true, 1, 1);
        gd_formText.minimumHeight = 100;
        gd_formText.heightHint = 62;
        formText.setLayoutData((Object)gd_formText);
        formText.marginHeight = 2;
        this.formToolkit.paintBordersFor((Composite)formText);
        formText.setText("Apogy is a multi-mission operations and planning software framework. Apogy uses Eclipse Modeling Framework models to define the systems being controlled, the environment in which these systems are operated, the operations being carried out and the corresponding data produced during operations.", false, false);
        Section sctnSupport = this.formToolkit.createSection(parent, 256);
        GridData gd_sctnSupport = new GridData(4, 4, true, true, 2, 1);
        gd_sctnSupport.widthHint = 452;
        sctnSupport.setLayoutData((Object)gd_sctnSupport);
        this.formToolkit.paintBordersFor((Composite)sctnSupport);
        sctnSupport.setText("Support");
        Composite composite_2 = this.formToolkit.createComposite((Composite)sctnSupport, 0);
        this.formToolkit.paintBordersFor(composite_2);
        sctnSupport.setClient((Control)composite_2);
        composite_2.setLayout((Layout)new GridLayout(2, false));
        this.formToolkit.createLabel(composite_2, "Web site");
        ImageHyperlink websSiteHyperLink = this.formToolkit.createImageHyperlink(composite_2, 0);
        websSiteHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    URL url = new URL("https://projects.eclipse.org/projects/technology.apogy");
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
                    externalBrowser.openURL(url);
                }
                catch (Exception exception) {
                    Logger.error("Unable to start external browser");
                }
            }
        });
        this.formToolkit.paintBordersFor((Composite)websSiteHyperLink);
        websSiteHyperLink.setText("https://projects.eclipse.org/projects/technology.apogy");
        websSiteHyperLink.setToolTipText("Apogy Web Site");
        this.formToolkit.createLabel(composite_2, "Documentation");
        ImageHyperlink docHyperLink = this.formToolkit.createImageHyperlink(composite_2, 0);
        docHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    URL url = new URL("https://wiki.eclipse.org/Apogy");
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
                    externalBrowser.openURL(url);
                }
                catch (Exception exception) {
                    Logger.error("Unable to start external browser");
                }
            }
        });
        this.formToolkit.paintBordersFor((Composite)docHyperLink);
        docHyperLink.setText("https://wiki.eclipse.org/Apogy");
        docHyperLink.setToolTipText("Documentation");
        this.formToolkit.createLabel(composite_2, "Resources");
        ImageHyperlink resourcesHyperLink = this.formToolkit.createImageHyperlink(composite_2, 0);
        resourcesHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    URL url = new URL("https://projects.eclipse.org/projects/technology.apogy/developer");
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
                    externalBrowser.openURL(url);
                }
                catch (Exception exception) {
                    Logger.error("Unable to start external browser");
                }
            }
        });
        this.formToolkit.paintBordersFor((Composite)resourcesHyperLink);
        resourcesHyperLink.setText("https://projects.eclipse.org/projects/technology.apogy/developer");
        resourcesHyperLink.setToolTipText("Resources");
        this.formToolkit.createLabel(composite_2, "Forum");
        ImageHyperlink forumHyperLink = this.formToolkit.createImageHyperlink(composite_2, 0);
        forumHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    URL url = new URL("https://www.eclipse.org/forums/index.php/f/401/");
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
                    externalBrowser.openURL(url);
                }
                catch (Exception exception) {
                    Logger.error("Unable to start external browser");
                }
            }
        });
        this.formToolkit.paintBordersFor((Composite)forumHyperLink);
        forumHyperLink.setText("https://www.eclipse.org/forums/index.php/f/401/");
        forumHyperLink.setToolTipText("Forum");
        this.formToolkit.createLabel(composite_2, "Bugs List");
        ImageHyperlink bugsListHyperLink = this.formToolkit.createImageHyperlink(composite_2, 0);
        bugsListHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    URL url = new URL("https://bugs.eclipse.org/bugs/buglist.cgi?classification=Technology&component=General&list_id=18509962&product=Apogy&query_format=advanced");
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
                    externalBrowser.openURL(url);
                }
                catch (Exception exception) {
                    Logger.error("Unable to start external browser");
                }
            }
        });
        this.formToolkit.paintBordersFor((Composite)bugsListHyperLink);
        bugsListHyperLink.setText("https://bugs.eclipse.org/bugs/buglist.cgi?classification=Technology&component=General&list_id=18509962&product=Apogy&query_format=advanced");
        bugsListHyperLink.setToolTipText("List of bugs");
        this.formToolkit.createLabel(composite_2, "Submit Bug");
        ImageHyperlink submitBugHyperLink = this.formToolkit.createImageHyperlink(composite_2, 0);
        submitBugHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    URL url = new URL("https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Apogy&component=General");
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
                    externalBrowser.openURL(url);
                }
                catch (Exception exception) {
                    Logger.error("Unable to start external browser");
                }
            }
        });
        this.formToolkit.paintBordersFor((Composite)submitBugHyperLink);
        submitBugHyperLink.setText("https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Apogy&component=General");
        submitBugHyperLink.setToolTipText("List of bugs");
    }

    @Focus
    public void setFocus() {
    }
}

