/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.browser.BrowserViewer;

public class WebBrowserViewDropAdapter
extends DropTargetAdapter {
    private BrowserViewer view;
    private int currentOperation = 0;
    private int lastValidOperation = 0;

    protected WebBrowserViewDropAdapter(BrowserViewer view) {
        this.view = view;
    }

    private void doDropValidation(DropTargetEvent event) {
        if (event.detail != 0) {
            this.lastValidOperation = event.detail;
        }
        this.currentOperation = this.validateDrop(event.detail, event.currentDataType) ? this.lastValidOperation : 0;
        event.detail = this.currentOperation;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.doDropValidation(event);
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 1;
        this.doDropValidation(event);
    }

    public void drop(DropTargetEvent event) {
        if (!this.performDrop(event.data)) {
            event.detail = 0;
        }
        this.currentOperation = event.detail;
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.validateDrop(event.detail, event.currentDataType)) {
            event.detail = 0;
        }
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = 1;
        }
        this.doDropValidation(event);
    }

    protected boolean performDrop(Object data) {
        if (data instanceof String[]) {
            String[] s = (String[])data;
            if (s.length == 0) {
                return true;
            }
            File f = new File(s[0]);
            try {
                this.view.setURL(f.toURI().toURL().toExternalForm());
            }
            catch (Exception exception) {}
        }
        return true;
    }

    protected boolean validateDrop(int operation, TransferData transferType) {
        return FileTransfer.getInstance().isSupportedType(transferType);
    }
}

