/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.frameworks.internal.ISaveHandler;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.IWFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class SaveHandlerHeadless
implements ISaveHandler {
    public void access() {
    }

    public void handleSaveFailed(SaveFailedException ex, IProgressMonitor monitor) {
        throw ex;
    }

    public static boolean isFailedWriteFileFailure(IWFTWrappedException ex) {
        Exception nested = ex.getInnerMostNestedException();
        if (nested == null) {
            return false;
        }
        return SaveHandlerHeadless.isFailedWriteFileFailure(nested);
    }

    public static boolean isFailedWriteFileFailure(Exception ex) {
        if (ex instanceof IWFTWrappedException) {
            return SaveHandlerHeadless.isFailedWriteFileFailure((IWFTWrappedException)((Object)ex));
        }
        if (ex instanceof CoreException) {
            return SaveHandlerHeadless.isFailedWriteFileFailure((CoreException)((Object)ex));
        }
        return false;
    }

    public static boolean isFailedWriteFileFailure(CoreException ex) {
        IStatus status = ex.getStatus();
        if (status == null) {
            return false;
        }
        Throwable nested = status.getException();
        if (nested instanceof CoreException) {
            return SaveHandlerHeadless.isFailedWriteFileFailure((CoreException)nested);
        }
        return status.getCode() == 272;
    }

    public void release() {
    }

    public boolean shouldContinueAndMakeFileEditable(IFile aFile) {
        if (aFile == null) {
            return false;
        }
        String error = WTPResourceHandler.getString("Unable_to_save_read-only_f_ERROR_", new Object[]{aFile.getFullPath()});
        WTPCommonPlugin.logError(error);
        return false;
    }
}

