/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.AbstractList;
import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.AbstractPathElement;

abstract class AbstractPathElementList<V, E, T extends AbstractPathElement<V, E>>
extends AbstractList<T>
implements Cloneable {
    protected Graph<V, E> graph;
    protected int maxSize;
    protected ArrayList<T> pathElements = new ArrayList();
    protected V vertex;

    protected AbstractPathElementList(Graph<V, E> graph, int maxSize, T pathElement) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        if (pathElement == null) {
            throw new NullPointerException("pathElement is null");
        }
        this.graph = graph;
        this.maxSize = maxSize;
        this.vertex = ((AbstractPathElement)pathElement).getVertex();
        this.pathElements.add(pathElement);
    }

    protected AbstractPathElementList(Graph<V, E> graph, int maxSize, AbstractPathElementList<V, E, T> elementList, E edge) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        if (elementList == null) {
            throw new NullPointerException("elementList is null");
        }
        if (edge == null) {
            throw new NullPointerException("edge is null");
        }
        this.graph = graph;
        this.maxSize = maxSize;
        this.vertex = Graphs.getOppositeVertex(graph, edge, elementList.getVertex());
    }

    protected AbstractPathElementList(AbstractPathElementList<V, E, T> original) {
        this.graph = original.graph;
        this.maxSize = original.maxSize;
        this.pathElements.addAll(original.pathElements);
        this.vertex = original.vertex;
    }

    @Override
    public T get(int index) {
        return (T)((AbstractPathElement)this.pathElements.get(index));
    }

    public V getVertex() {
        return this.vertex;
    }

    @Override
    public int size() {
        return this.pathElements.size();
    }
}

