/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class CompleteBipartiteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int sizeA;
    private int sizeB;

    public CompleteBipartiteGraphGenerator(int partitionOne, int partitionTwo) {
        if (partitionOne < 0 || partitionTwo < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.sizeA = partitionOne;
        this.sizeB = partitionTwo;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        V newVertex;
        if (this.sizeA < 1 && this.sizeB < 1) {
            return;
        }
        HashSet<V> a = new HashSet<V>();
        HashSet<V> b = new HashSet<V>();
        int i = 0;
        while (i < this.sizeA) {
            newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            a.add(newVertex);
            ++i;
        }
        i = 0;
        while (i < this.sizeB) {
            newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            b.add(newVertex);
            ++i;
        }
        for (Object v : a) {
            Iterator iterB = b.iterator();
            while (iterB.hasNext()) {
                target.addEdge(v, iterB.next());
            }
        }
    }
}

