/*
 * Decompiled with CFR 0.152.
 */
package org.orekit;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DirectoryCrawler;
import org.orekit.time.TimeScalesFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    public static String ID = "org.orekit";
    public static final String DATA_FOLDER = "data";
    private static Activator plugin;
    private static BundleContext context;
    private java.nio.file.Path tmpPath;

    public static BundleContext getContext() {
        return context;
    }

    public Activator() {
        plugin = this;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        try {
            Activator.logMessage(this, "Loading OreKit data...", 1);
            this.tmpPath = this.copyDataFolderToTemp(DATA_FOLDER);
            Activator.logMessage(this, "OreKit Data Files have been copied to <" + this.tmpPath + ">", 1);
            DataProvidersManager.getInstance().addProvider((DataProvider)new DirectoryCrawler(this.tmpPath.toFile()));
            try {
                TimeScalesFactory.getUTC();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Activator.logMessage(this, "Sucessfully loaded OreKit data.", 0);
        }
        catch (Throwable t) {
            Activator.logMessage(this, "Error cocured when loading OreKit Data !", 4, t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        Activator.deleteFile(this.tmpPath.toFile());
        Activator.context = null;
    }

    public static void deleteFile(File element) {
        if (element.isDirectory()) {
            File[] fileArray = element.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                Activator.deleteFile(sub);
                ++n2;
            }
        }
        element.delete();
    }

    public static FrameworkLog getLog() {
        if (Activator.getContext() != null) {
            ServiceReference logService = Activator.getContext().getServiceReference("org.eclipse.osgi.framework.log.FrameworkLog");
            FrameworkLog log = (FrameworkLog)Activator.getContext().getService(logService);
            return log;
        }
        return null;
    }

    public static void logMessage(Object object, String message, int severity, Throwable throwable) {
        String fullMessage = String.valueOf(object.getClass().getSimpleName()) + " : " + message;
        FrameworkLogEntry logEntry = new FrameworkLogEntry(Activator.getContext().getBundle().getSymbolicName(), severity, 0, fullMessage, 0, throwable, null);
        if (Activator.getLog() != null) {
            Activator.getLog().log(logEntry);
        }
    }

    public static void logMessage(Object object, String message, int severity) {
        Activator.logMessage(object, message, severity, null);
    }

    private java.nio.file.Path copyDataFolderToTemp(String folderPath) throws Exception {
        java.nio.file.Path tempPath = Files.createTempDirectory("oreKit_", new FileAttribute[0]);
        Activator.logMessage(this, "Created temporary folder <" + tempPath.toAbsolutePath().toAbsolutePath() + "> for OreKit Data Files.", 0);
        Activator.logMessage(this, "Searching folder <" + folderPath + "> for OreKit Data Files...", 1);
        Enumeration entries = Activator.getContext().getBundle().getEntryPaths(folderPath);
        int fileCount = 0;
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            try {
                String fileName = entry.substring(entry.lastIndexOf(File.separator) + 1);
                fileName = entry.substring(entry.indexOf(folderPath) + folderPath.length() + 1);
                Activator.logMessage(this, "Processing file <" + fileName + ">", 1);
                URL url = Activator.getContext().getBundle().getEntry(entry);
                Path p = new Path(String.valueOf(ID) + File.separator + File.separator + url.getFile());
                if (p.hasTrailingSeparator()) continue;
                InputStream input = url.openConnection().getInputStream();
                java.nio.file.Path destinationPath = FileSystems.getDefault().getPath(tempPath.toAbsolutePath().toString(), fileName);
                Activator.logMessage(this, "Coping file from <" + p.toOSString() + "> to <" + destinationPath.toAbsolutePath().toString() + ">...", 1);
                Files.copy(input, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                Activator.logMessage(this, "Copied File [" + fileCount + "] <" + fileName + "> to <" + destinationPath.toAbsolutePath().toString() + ">.", 0);
                ++fileCount;
            }
            catch (Exception e) {
                Activator.logMessage(this, "Failed to copy entry <" + entry + "> to temporary folder.", 4);
                e.printStackTrace();
            }
        }
        return tempPath;
    }
}

