/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.ros.internal.message.context.MessageContext;
import org.ros.internal.message.context.MessageContextBuilder;
import org.ros.internal.message.definition.MessageDefinitionParser;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageFactory;

public class MessageContextProvider {
    private final Map<MessageDeclaration, MessageContext> cache;
    private final MessageFactory messageFactory;

    public MessageContextProvider(MessageFactory messageFactory) {
        Preconditions.checkNotNull((Object)messageFactory);
        this.messageFactory = messageFactory;
        this.cache = Maps.newConcurrentMap();
    }

    public MessageContext get(MessageDeclaration messageDeclaration) {
        MessageContext messageContext = this.cache.get(messageDeclaration);
        if (messageContext == null) {
            messageContext = new MessageContext(messageDeclaration, this.messageFactory);
            MessageContextBuilder visitor = new MessageContextBuilder(messageContext);
            MessageDefinitionParser messageDefinitionParser = new MessageDefinitionParser(visitor);
            messageDefinitionParser.parse(messageDeclaration.getType(), messageDeclaration.getDefinition());
            this.cache.put(messageDeclaration, messageContext);
        }
        return messageContext;
    }
}

