/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.service;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.ros.internal.message.StringResourceProvider;
import org.ros.message.MessageDefinitionProvider;
import org.ros.message.MessageIdentifier;

public class ServiceDefinitionResourceProvider
implements MessageDefinitionProvider {
    private final StringResourceProvider stringResourceProvider = new StringResourceProvider();

    private String serviceTypeToResourceName(String serviceType) {
        Preconditions.checkArgument((boolean)serviceType.contains("/"), (Object)("Service type must be fully qualified: " + serviceType));
        String[] packageAndType = serviceType.split("/", 2);
        return String.format("/%s/srv/%s.srv", packageAndType[0], packageAndType[1]);
    }

    @Override
    public String get(String serviceType) {
        return this.stringResourceProvider.get(this.serviceTypeToResourceName(serviceType));
    }

    @Override
    public boolean has(String serviceType) {
        return this.stringResourceProvider.has(this.serviceTypeToResourceName(serviceType));
    }

    public void add(String serviceType, String serviceDefinition) {
        this.stringResourceProvider.addStringToCache(this.serviceTypeToResourceName(serviceType), serviceDefinition);
    }

    @Override
    public Collection<String> getPackages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<MessageIdentifier> getMessageIdentifiersByPackage(String pkg) {
        throw new UnsupportedOperationException();
    }
}

