/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import com.google.common.base.Preconditions;

public abstract class CancellableLoop
implements Runnable {
    private final Object mutex = new Object();
    private boolean ranOnce = false;
    private Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.mutex;
        synchronized (object) {
            Preconditions.checkState((!this.ranOnce ? 1 : 0) != 0, (Object)"CancellableLoops cannot be restarted.");
            this.ranOnce = true;
            this.thread = Thread.currentThread();
        }
        try {
            try {
                this.setup();
                while (!this.thread.isInterrupted()) {
                    this.loop();
                }
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
                this.thread = null;
            }
        }
        finally {
            this.thread = null;
        }
    }

    protected void setup() {
    }

    protected abstract void loop() throws InterruptedException;

    protected void handleInterruptedException(InterruptedException e) {
    }

    public void cancel() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public boolean isRunning() {
        return this.thread != null && !this.thread.isInterrupted();
    }
}

