/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import org.ros.concurrent.Rate;

public class WallTimeRate
implements Rate {
    private final long delay;
    private long time;

    public WallTimeRate(int hz) {
        this.delay = 1000 / hz;
        this.time = 0L;
    }

    @Override
    public void sleep() {
        long delta = System.currentTimeMillis() - this.time;
        while (delta < this.delay) {
            try {
                Thread.sleep(this.delay - delta);
            }
            catch (InterruptedException e) {
                break;
            }
            delta = System.currentTimeMillis() - this.time;
        }
        this.time = System.currentTimeMillis();
    }
}

