/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.client;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.concurrent.Holder;
import org.ros.concurrent.RetryingExecutorService;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.node.client.MasterClient;
import org.ros.internal.node.response.Response;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.service.DefaultServiceServer;
import org.ros.internal.node.service.ServiceManagerListener;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.node.topic.DefaultSubscriber;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.TopicParticipantManagerListener;

public class Registrar
implements TopicParticipantManagerListener,
ServiceManagerListener {
    private static final boolean DEBUG = true;
    private static final Log log = LogFactory.getLog(Registrar.class);
    private static final int SHUTDOWN_TIMEOUT = 5;
    private static final TimeUnit SHUTDOWN_TIMEOUT_UNITS = TimeUnit.SECONDS;
    private final MasterClient masterClient;
    private final ScheduledExecutorService executorService;
    private final RetryingExecutorService retryingExecutorService;
    private NodeIdentifier nodeIdentifier;
    private boolean running;

    public Registrar(MasterClient masterClient, ScheduledExecutorService executorService) {
        this.masterClient = masterClient;
        this.executorService = executorService;
        this.retryingExecutorService = new RetryingExecutorService(executorService);
        this.nodeIdentifier = null;
        this.running = false;
        log.info((Object)("MasterXmlRpcEndpoint URI: " + masterClient.getRemoteUri()));
    }

    public void setRetryDelay(long delay, TimeUnit unit) {
        this.retryingExecutorService.setRetryDelay(delay, unit);
    }

    private boolean submit(Callable<Boolean> callable) {
        if (this.running) {
            this.retryingExecutorService.submit(callable);
            return true;
        }
        log.warn((Object)"Registrar no longer running, request ignored.");
        return false;
    }

    private <T> boolean callMaster(Callable<Response<T>> callable) {
        boolean success;
        Preconditions.checkNotNull((Object)this.nodeIdentifier, (Object)"Registrar not started.");
        try {
            Response<T> response = callable.call();
            log.info(response);
            success = response.isSuccess();
        }
        catch (Exception e) {
            log.error((Object)"Exception caught while communicating with master.", (Throwable)e);
            success = false;
        }
        return success;
    }

    @Override
    public void onPublisherAdded(final DefaultPublisher<?> publisher) {
        log.info((Object)("Registering publisher: " + publisher));
        boolean submitted = this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = Registrar.this.callMaster(new Callable<Response<List<URI>>>(){

                    @Override
                    public Response<List<URI>> call() throws Exception {
                        return Registrar.this.masterClient.registerPublisher(publisher.toDeclaration());
                    }
                });
                if (success) {
                    publisher.signalOnMasterRegistrationSuccess();
                } else {
                    publisher.signalOnMasterRegistrationFailure();
                }
                return !success;
            }
        });
        if (!submitted) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    publisher.signalOnMasterRegistrationFailure();
                }
            });
        }
    }

    @Override
    public void onPublisherRemoved(final DefaultPublisher<?> publisher) {
        log.info((Object)("Unregistering publisher: " + publisher));
        boolean submitted = this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = Registrar.this.callMaster(new Callable<Response<Integer>>(){

                    @Override
                    public Response<Integer> call() throws Exception {
                        return Registrar.this.masterClient.unregisterPublisher(publisher.getIdentifier());
                    }
                });
                if (success) {
                    publisher.signalOnMasterUnregistrationSuccess();
                } else {
                    publisher.signalOnMasterUnregistrationFailure();
                }
                return !success;
            }
        });
        if (!submitted) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    publisher.signalOnMasterUnregistrationFailure();
                }
            });
        }
    }

    @Override
    public void onSubscriberAdded(final DefaultSubscriber<?> subscriber) {
        log.info((Object)("Registering subscriber: " + subscriber));
        boolean submitted = this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                final Holder holder = Holder.newEmpty();
                boolean success = Registrar.this.callMaster(new Callable<Response<List<URI>>>(){

                    @Override
                    public Response<List<URI>> call() throws Exception {
                        return holder.set(Registrar.this.masterClient.registerSubscriber(Registrar.this.nodeIdentifier, subscriber));
                    }
                });
                if (success) {
                    Collection<PublisherIdentifier> publisherIdentifiers = PublisherIdentifier.newCollectionFromUris((Collection)((Response)holder.get()).getResult(), subscriber.getTopicDeclaration());
                    subscriber.updatePublishers(publisherIdentifiers);
                    subscriber.signalOnMasterRegistrationSuccess();
                } else {
                    subscriber.signalOnMasterRegistrationFailure();
                }
                return !success;
            }
        });
        if (!submitted) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    subscriber.signalOnMasterRegistrationFailure();
                }
            });
        }
    }

    @Override
    public void onSubscriberRemoved(final DefaultSubscriber<?> subscriber) {
        log.info((Object)("Unregistering subscriber: " + subscriber));
        boolean submitted = this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = Registrar.this.callMaster(new Callable<Response<Integer>>(){

                    @Override
                    public Response<Integer> call() throws Exception {
                        return Registrar.this.masterClient.unregisterSubscriber(Registrar.this.nodeIdentifier, subscriber);
                    }
                });
                if (success) {
                    subscriber.signalOnMasterUnregistrationSuccess();
                } else {
                    subscriber.signalOnMasterUnregistrationFailure();
                }
                return !success;
            }
        });
        if (!submitted) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    subscriber.signalOnMasterUnregistrationFailure();
                }
            });
        }
    }

    @Override
    public void onServiceServerAdded(final DefaultServiceServer<?, ?> serviceServer) {
        log.info((Object)("Registering service: " + serviceServer));
        boolean submitted = this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = Registrar.this.callMaster(new Callable<Response<Void>>(){

                    @Override
                    public Response<Void> call() throws Exception {
                        return Registrar.this.masterClient.registerService(Registrar.this.nodeIdentifier, serviceServer);
                    }
                });
                if (success) {
                    serviceServer.signalOnMasterRegistrationSuccess();
                } else {
                    serviceServer.signalOnMasterRegistrationFailure();
                }
                return !success;
            }
        });
        if (!submitted) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    serviceServer.signalOnMasterRegistrationFailure();
                }
            });
        }
    }

    @Override
    public void onServiceServerRemoved(final DefaultServiceServer<?, ?> serviceServer) {
        log.info((Object)("Unregistering service: " + serviceServer));
        boolean submitted = this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = Registrar.this.callMaster(new Callable<Response<Integer>>(){

                    @Override
                    public Response<Integer> call() throws Exception {
                        return Registrar.this.masterClient.unregisterService(Registrar.this.nodeIdentifier, serviceServer);
                    }
                });
                if (success) {
                    serviceServer.signalOnMasterUnregistrationSuccess();
                } else {
                    serviceServer.signalOnMasterUnregistrationFailure();
                }
                return !success;
            }
        });
        if (!submitted) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    serviceServer.signalOnMasterUnregistrationFailure();
                }
            });
        }
    }

    public void start(NodeIdentifier nodeIdentifier) {
        Preconditions.checkNotNull((Object)nodeIdentifier);
        Preconditions.checkState((this.nodeIdentifier == null ? 1 : 0) != 0, (Object)"Registrar already started.");
        this.nodeIdentifier = nodeIdentifier;
        this.running = true;
    }

    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.retryingExecutorService.shutdown(5L, SHUTDOWN_TIMEOUT_UNITS);
        }
        catch (InterruptedException e) {
            throw new RosRuntimeException(e);
        }
    }
}

