/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.queue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.ros.concurrent.CircularBlockingDeque;
import org.ros.internal.transport.queue.LazyMessage;
import org.ros.internal.transport.tcp.AbstractNamedChannelHandler;
import org.ros.message.MessageDeserializer;

public class MessageReceiver<T>
extends AbstractNamedChannelHandler {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(MessageReceiver.class);
    private final CircularBlockingDeque<LazyMessage<T>> lazyMessages;
    private final MessageDeserializer<T> deserializer;

    public MessageReceiver(CircularBlockingDeque<LazyMessage<T>> lazyMessages, MessageDeserializer<T> deserializer) {
        this.lazyMessages = lazyMessages;
        this.deserializer = deserializer;
    }

    @Override
    public String getName() {
        return "IncomingMessageQueueChannelHandler";
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        this.lazyMessages.addLast(new LazyMessage<T>(buffer.copy(), this.deserializer));
        super.messageReceived(ctx, e);
    }
}

