/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.converters;

import java.io.InputStream;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.core.resources.IFile;

public class TopoIFileToCartesianTriangularMeshConverter
implements IConverter {
    public Class<?> getOutputType() {
        return CartesianTriangularMesh.class;
    }

    public Class<?> getInputType() {
        return IFile.class;
    }

    public boolean canConvert(Object input) {
        if (input instanceof IFile) {
            IFile file = (IFile)input;
            return this.getFileExtension(file.getName()).endsWith(".topo");
        }
        return false;
    }

    public Object convert(Object input) throws Exception {
        IFile file = (IFile)input;
        InputStream inputStream = file.getContents();
        return Data3DIO.INSTANCE.loadTriangularMesh(inputStream);
    }

    protected String getFileExtension(String url) {
        String fileExtension = new String();
        String fileName = url;
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            fileExtension = fileName.substring(index);
            fileExtension = fileExtension.toLowerCase();
        }
        return fileExtension;
    }
}

