/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.awt.Color;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DUtils;
import org.eclipse.apogy.common.geometry.data3d.RGBAColor;
import org.eclipse.apogy.common.geometry.data3d.impl.CartesianTriangularMeshColorizerBySlopeImpl;

public class CartesianTriangularMeshColorizerBySlopeCustomImpl
extends CartesianTriangularMeshColorizerBySlopeImpl {
    @Override
    public RGBAColor computeColor(CartesianTriangularMesh mesh, CartesianPositionCoordinates point) {
        Vector3d normal = Data3DUtils.INSTANCE.computeNormalAtVertex(mesh, point);
        normal.normalize();
        Vector3d axis = null;
        switch (this.getNormalAxis().getValue()) {
            case 0: {
                axis = new Vector3d(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                axis = new Vector3d(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                axis = new Vector3d(0.0, 0.0, 1.0);
            }
        }
        double angle = axis.angle(normal);
        double factor = angle / Math.PI;
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (factor > 1.0) {
            factor = 1.0;
        }
        float hue = (float)(0.666 - factor * 0.666);
        Color color = Color.getHSBColor(hue, 0.9f, 0.9f);
        return ApogyCommonGeometryData3DFacade.INSTANCE.createRGBAColor((byte)color.getAlpha(), (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
    }
}

