/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMap;
import org.eclipse.apogy.common.geometry.data3d.impl.DigitalElevationMapMesherImpl;

public class DigitalElevationMapMesherCustomImpl
extends DigitalElevationMapMesherImpl {
    public CartesianTriangularMesh process(DigitalElevationMap input) throws Exception {
        CartesianTriangularMesh result = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        for (CartesianPositionCoordinates p : input.getPoints()) {
            CartesianPositionCoordinates copy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(p);
            points.add(copy);
        }
        result.getPoints().addAll(points);
        CartesianPositionCoordinates[][] array = this.createPointsArray((List<CartesianPositionCoordinates>)result.getPoints(), input.getXDimension(), input.getYDimension());
        ArrayList<CartesianTriangle> triangles = new ArrayList<CartesianTriangle>();
        int ym = 0;
        while (ym < input.getYDimension() - 1) {
            int xn = 0;
            while (xn < input.getXDimension() - 1) {
                CartesianPositionCoordinates pa = array[xn][ym];
                CartesianPositionCoordinates pb = array[xn + 1][ym];
                CartesianPositionCoordinates pc = array[xn + 1][ym + 1];
                CartesianPositionCoordinates pd = array[xn][ym + 1];
                CartesianTriangle t1 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(pa, pb, pc);
                triangles.add(t1);
                CartesianTriangle t2 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(pa, pc, pd);
                triangles.add(t2);
                ++xn;
            }
            ++ym;
        }
        result.getPolygons().addAll(triangles);
        return result;
    }

    private CartesianPositionCoordinates[][] createPointsArray(List<CartesianPositionCoordinates> points, int xDimension, int yDimension) {
        CartesianPositionCoordinates[][] array = new CartesianPositionCoordinates[xDimension][yDimension];
        int i = 0;
        while (i < xDimension) {
            int startIndex = i * yDimension;
            int j = 0;
            while (j < yDimension) {
                array[i][j] = points.get(startIndex + j);
                ++j;
            }
            ++i;
        }
        return array;
    }
}

