/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.impl.KDTreeBasedPointLocatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDTreeBasedPointLocatorCustomImpl
extends KDTreeBasedPointLocatorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(KDTreeBasedPointLocatorImpl.class);
    List<CartesianPositionCoordinates> pointsToSearch = new ArrayList<CartesianPositionCoordinates>();
    private boolean isDirty;
    private KDTree kdTree;
    private double[] queryBuffer1;
    private double[] queryBuffer2;

    protected void finalize() throws Throwable {
        this.pointsToSearch.clear();
        super.finalize();
    }

    @Override
    public List<CartesianPositionCoordinates> getPoints() {
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        points.addAll(this.pointsToSearch);
        return points;
    }

    @Override
    public void addPoint(CartesianPositionCoordinates point) {
        this.isDirty = true;
        this.pointsToSearch.add(point);
    }

    @Override
    public void addPoints(List<CartesianPositionCoordinates> points) {
        this.isDirty = true;
        this.pointsToSearch.addAll(points);
    }

    @Override
    public void removePoint(CartesianPositionCoordinates point) {
        this.isDirty = true;
        this.pointsToSearch.remove(point);
    }

    @Override
    public void removePoints(List<CartesianPositionCoordinates> points) {
        this.isDirty = true;
        this.pointsToSearch.removeAll(points);
    }

    @Override
    public void clearPoints() {
        this.isDirty = true;
        this.pointsToSearch.clear();
    }

    @Override
    public CartesianPositionCoordinates findClosestPoint(CartesianPositionCoordinates point) {
        if (this.pointsToSearch.isEmpty()) {
            return null;
        }
        this.getQueryBuffer1()[0] = point.getX();
        this.getQueryBuffer1()[1] = point.getY();
        this.getQueryBuffer1()[2] = point.getZ();
        CartesianPositionCoordinates closestPoint = null;
        try {
            Object nearest = this.getKdTree().nearest(this.getQueryBuffer1());
            if (nearest != null) {
                closestPoint = this.pointsToSearch.get((Integer)nearest);
            }
        }
        catch (KeySizeException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return closestPoint;
    }

    @Override
    public List<CartesianPositionCoordinates> findClosestPoints(CartesianPositionCoordinates point, int maximumNumberOfNeighbors) {
        if (point == null) {
            throw new IllegalArgumentException();
        }
        if (maximumNumberOfNeighbors <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.pointsToSearch.isEmpty()) {
            return null;
        }
        try {
            Object[] nearest = this.getKdTree().nearest(this.getQueryBuffer1(), maximumNumberOfNeighbors);
            ArrayList<CartesianPositionCoordinates> neighbors = new ArrayList<CartesianPositionCoordinates>();
            int i = 0;
            while (i < nearest.length) {
                CartesianPositionCoordinates neighbor = this.pointsToSearch.get((Integer)nearest[i]);
                neighbors.add(neighbor);
                ++i;
            }
            return neighbors;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException();
        }
        catch (KeySizeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public List<CartesianPositionCoordinates> findPointsWithinRadius(CartesianPositionCoordinates point, double radius) {
        if (point == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<CartesianPositionCoordinates> neighbors = new ArrayList<CartesianPositionCoordinates>();
        if (this.pointsToSearch.isEmpty()) {
            return neighbors;
        }
        this.getQueryBuffer1()[0] = point.getX() - Math.abs(radius);
        this.getQueryBuffer1()[1] = point.getY() - Math.abs(radius);
        this.getQueryBuffer1()[2] = point.getZ() - Math.abs(radius);
        this.getQueryBuffer2()[0] = point.getX() + Math.abs(radius);
        this.getQueryBuffer2()[1] = point.getY() + Math.abs(radius);
        this.getQueryBuffer2()[2] = point.getZ() + Math.abs(radius);
        try {
            Object[] range = this.getKdTree().range(this.getQueryBuffer1(), this.getQueryBuffer2());
            int i = 0;
            while (i < range.length) {
                CartesianPositionCoordinates p = this.pointsToSearch.get((Integer)range[i]);
                if (p.asPoint3d().distance(point.asPoint3d()) < radius) {
                    neighbors.add(this.pointsToSearch.get((Integer)range[i]));
                }
                ++i;
            }
        }
        catch (KeySizeException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return neighbors;
    }

    private KDTree getKdTree() {
        if (this.kdTree == null || this.isDirty) {
            if (this.pointsToSearch == null) {
                throw new IllegalArgumentException();
            }
            this.kdTree = new KDTree(3);
            int pid = 0;
            for (CartesianPositionCoordinates point : this.pointsToSearch) {
                double[] key = new double[]{point.getX(), point.getY(), point.getZ()};
                try {
                    this.kdTree.insert(key, (Object)pid++);
                }
                catch (KeySizeException e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
                catch (KeyDuplicateException keyDuplicateException) {
                    // empty catch block
                }
            }
            this.isDirty = false;
        }
        return this.kdTree;
    }

    private double[] getQueryBuffer1() {
        if (this.queryBuffer1 == null) {
            this.queryBuffer1 = new double[3];
        }
        return this.queryBuffer1;
    }

    private double[] getQueryBuffer2() {
        if (this.queryBuffer2 == null) {
            this.queryBuffer2 = new double[3];
        }
        return this.queryBuffer2;
    }
}

