/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.List;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.geometry.data3d.impl.VoxelBased3DPointCloudResamplerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoxelBased3DPointCloudResamplerCustomImpl
extends VoxelBased3DPointCloudResamplerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(VoxelBased3DPointCloudResamplerImpl.class);

    public CartesianCoordinatesSet process(CartesianCoordinatesSet input) throws Exception {
        this.setInput(input);
        Logger.info("Resampling point clound containing <" + input.getPoints().size() + "> points...");
        CartesianCoordinatesSet out = this.resample(this.getResolutionX(), this.getResolutionY(), this.getResolutionZ(), this.getMinimumNumberOfPointPerVoxel(), this.getTileResolution(), (CartesianCoordinatesSet)this.getInput());
        Logger.info("Resampling completed. Resulting point clound contains <" + out.getPoints().size() + "> points.");
        this.setOutput(out);
        return (CartesianCoordinatesSet)this.getOutput();
    }

    private double[] getPointCloudsBounds(CartesianCoordinatesSet pointCloud) {
        double[] bounds = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        CartesianPositionCoordinates minX = Geometry3DUtilities.getMinimumPosition(CartesianAxis.X, (List<CartesianPositionCoordinates>)pointCloud.getPoints());
        CartesianPositionCoordinates minY = Geometry3DUtilities.getMinimumPosition(CartesianAxis.Y, (List<CartesianPositionCoordinates>)pointCloud.getPoints());
        CartesianPositionCoordinates minZ = Geometry3DUtilities.getMinimumPosition(CartesianAxis.Z, (List<CartesianPositionCoordinates>)pointCloud.getPoints());
        CartesianPositionCoordinates maxX = Geometry3DUtilities.getMaximumPosition(CartesianAxis.X, (List<CartesianPositionCoordinates>)pointCloud.getPoints());
        CartesianPositionCoordinates maxY = Geometry3DUtilities.getMaximumPosition(CartesianAxis.Y, (List<CartesianPositionCoordinates>)pointCloud.getPoints());
        CartesianPositionCoordinates maxZ = Geometry3DUtilities.getMaximumPosition(CartesianAxis.Z, (List<CartesianPositionCoordinates>)pointCloud.getPoints());
        bounds[0] = minX.getX();
        bounds[1] = maxX.getX();
        bounds[2] = minY.getY();
        bounds[3] = maxY.getY();
        bounds[4] = minZ.getZ();
        bounds[5] = maxZ.getZ();
        return bounds;
    }

    private CartesianCoordinatesSet resample(double resolutionx, double resolutiony, double resolutionz, int minpoints, double coarseresolution, CartesianCoordinatesSet inputPointCloud) {
        int kmax;
        int jmax;
        CartesianCoordinatesSet outputPointCloud = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        double[] bounds = null;
        int size = inputPointCloud.getPoints().size();
        bounds = this.getPointCloudsBounds(inputPointCloud);
        double xmin = bounds[0];
        double xmax = bounds[1];
        double ymin = bounds[2];
        double ymax = bounds[3];
        double zmin = bounds[4];
        double zmax = bounds[5];
        double sidex = Math.abs(xmax - xmin);
        double sidey = Math.abs(ymax - ymin);
        double sidez = Math.abs(zmax - zmin);
        int imax = (int)Math.ceil(sidey / coarseresolution);
        if (imax == 0) {
            imax = 1;
        }
        if ((jmax = (int)Math.ceil(sidex / coarseresolution)) == 0) {
            jmax = 1;
        }
        if ((kmax = (int)Math.ceil(sidez / coarseresolution)) == 0) {
            kmax = 1;
        }
        Vector coarse3Dgrid = new Vector(imax * jmax * kmax);
        int i = 0;
        while (i < imax * jmax * kmax) {
            coarse3Dgrid.add(new Vector());
            ++i;
        }
        double den = 1.0 / coarseresolution;
        i = 0;
        while (i < size) {
            Point3d p = ((CartesianPositionCoordinates)inputPointCloud.getPoints().get(i)).asPoint3d();
            double tmp = (p.y - ymin) * den;
            int ip = (int)tmp;
            tmp = (p.x - xmin) * den;
            int jp = (int)tmp;
            tmp = (p.z - zmin) * den;
            int kp = (int)tmp;
            ((Vector)coarse3Dgrid.get(jp + ip * jmax + kp * imax * jmax)).add(p);
            ++i;
        }
        Vector patch = new Vector();
        Vector<Object> outputPatch = new Vector();
        i = 0;
        while (i < coarse3Dgrid.size()) {
            patch = (Vector)coarse3Dgrid.get(i);
            if (patch.size() >= minpoints) {
                outputPatch = this.voxelize(resolutionx, resolutiony, resolutionz, minpoints, patch);
                int j = 0;
                while (j < outputPatch.size()) {
                    CartesianPositionCoordinates newPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(((Point3d)outputPatch.get((int)j)).x, ((Point3d)outputPatch.get((int)j)).y, ((Point3d)outputPatch.get((int)j)).z);
                    outputPointCloud.getPoints().add((Object)newPoint);
                    ++j;
                }
            }
            ++i;
        }
        coarse3Dgrid.clear();
        return outputPointCloud;
    }

    private Vector<Point3d> voxelize(double resolutionx, double resolutiony, double resolutionz, int minpoints, Vector<Point3d> data) {
        Point4d p;
        int kmax;
        int jmax;
        Vector<Point3d> output = new Vector<Point3d>();
        int size = data.size();
        if (size < minpoints) {
            return output;
        }
        double xmin = data.get((int)0).x;
        double xmax = data.get((int)0).x;
        double ymin = data.get((int)0).y;
        double ymax = data.get((int)0).y;
        double zmin = data.get((int)0).z;
        double zmax = data.get((int)0).z;
        int i = 0;
        while (i < size) {
            if (xmin > data.get((int)i).x) {
                xmin = data.get((int)i).x;
            }
            if (xmax < data.get((int)i).x) {
                xmax = data.get((int)i).x;
            }
            if (ymin > data.get((int)i).y) {
                ymin = data.get((int)i).y;
            }
            if (ymax < data.get((int)i).y) {
                ymax = data.get((int)i).y;
            }
            if (zmin > data.get((int)i).z) {
                zmin = data.get((int)i).z;
            }
            if (zmax < data.get((int)i).z) {
                zmax = data.get((int)i).z;
            }
            ++i;
        }
        double sidex = Math.abs(xmax - xmin);
        double sidey = Math.abs(ymax - ymin);
        double sidez = Math.abs(zmax - zmin);
        int imax = (int)Math.ceil(sidey / resolutiony);
        if (imax * (jmax = (int)Math.ceil(sidex / resolutionx)) * (kmax = (int)Math.ceil(sidez / resolutionz)) < minpoints) {
            return output;
        }
        Vector<Point4d> grid = new Vector<Point4d>(imax * jmax * kmax);
        i = 0;
        while (i < imax * jmax * kmax) {
            grid.add(new Point4d(0.0, 0.0, 0.0, 0.0));
            ++i;
        }
        double denx = 1.0 / resolutionx;
        double deny = 1.0 / resolutiony;
        double denz = 1.0 / resolutionz;
        i = 0;
        while (i < size) {
            double x = data.get((int)i).x;
            double y = data.get((int)i).y;
            double z = data.get((int)i).z;
            int ip = (int)((y - ymin) * deny);
            int jp = (int)((x - xmin) * denx);
            int kp = (int)((z - zmin) * denz);
            p = (Point4d)grid.get(jp + ip * jmax + kp * imax * jmax);
            p.x += x;
            p.y += y;
            p.z += z;
            p.w += 1.0;
            grid.set(jp + ip * jmax + kp * imax * jmax, p);
            ++i;
        }
        i = 0;
        while (i < grid.size()) {
            p = (Point4d)grid.get(i);
            int n = (int)p.w;
            if (n >= minpoints) {
                p.x /= (double)n;
                p.y /= (double)n;
                p.z /= (double)n;
                grid.set(i, p);
                output.add(new Point3d(p.x, p.y, p.z));
            }
            ++i;
        }
        grid.clear();
        return output;
    }
}

