/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.LocalStreamConnection;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestProcessor;
import org.xml.sax.SAXException;

public class XmlRpcLocalStreamTransport
extends XmlRpcStreamTransport {
    private final XmlRpcStreamRequestProcessor localServer;
    private LocalStreamConnection conn;
    private XmlRpcRequest request;

    public XmlRpcLocalStreamTransport(XmlRpcClient pClient, XmlRpcStreamRequestProcessor pServer) {
        super(pClient);
        this.localServer = pServer;
    }

    @Override
    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        return pConfig.isGzipRequesting();
    }

    @Override
    protected void close() throws XmlRpcClientException {
    }

    @Override
    protected InputStream getInputStream() throws XmlRpcException {
        this.localServer.execute(this.conn.getConfig(), this.conn.getServerStreamConnection());
        return new ByteArrayInputStream(this.conn.getResponse().toByteArray());
    }

    @Override
    protected XmlRpcStreamTransport.ReqWriter newReqWriter(XmlRpcRequest pRequest) throws XmlRpcException, IOException, SAXException {
        this.request = pRequest;
        return super.newReqWriter(pRequest);
    }

    @Override
    protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException, IOException, SAXException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pWriter.write(baos);
        XmlRpcStreamRequestConfig config = (XmlRpcStreamRequestConfig)this.request.getConfig();
        this.conn = new LocalStreamConnection(config, new ByteArrayInputStream(baos.toByteArray()));
    }
}

