/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;

public class SetCommand
extends AutoUndoCommand {
    protected EObject fTarget;
    protected EStructuralFeature fFeature = null;
    protected Object fNewValue;
    protected Object fOldValue;
    boolean fExecuteWasSkipped = false;

    public SetCommand(EObject aTarget, Object aValue) {
        super(aTarget);
        this.fTarget = aTarget;
        this.fNewValue = aValue;
    }

    public SetCommand(EObject aTarget, Object aValue, EStructuralFeature aFeature) {
        this(aTarget, aValue);
        this.fNewValue = aValue;
        this.fFeature = aFeature;
    }

    public Object get() {
        return this.fTarget.eGet(this.fFeature);
    }

    public void set(Object o) {
        this.fTarget.eSet(this.fFeature, o);
    }

    public void setNewValue(EObject newValue) {
        this.fNewValue = newValue;
    }

    public String getLabel() {
        if (this.fFeature == null) {
            return Messages.SetCommand_Change_1;
        }
        return NLS.bind((String)Messages.SetCommand_Change_2, (Object)this.fFeature.getName(), null);
    }

    protected boolean hasNoEffect() {
        if (this.fOldValue == null) {
            return this.fNewValue == null;
        }
        if (this.fNewValue == null) {
            return false;
        }
        return this.fNewValue.equals(this.fOldValue);
    }

    @Override
    public boolean canDoExecute() {
        return true;
    }

    @Override
    public void doExecute() {
        this.fOldValue = this.get();
        if (this.hasNoEffect()) {
            this.fExecuteWasSkipped = true;
        } else {
            this.set(this.fNewValue);
        }
    }
}

