/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkTypeTreeContentProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class PartnerLinkRoleSelectorDialog
extends StatusDialog {
    private int fSelectedRole;
    private EList<Role> fRoles;
    private Tree fTree;
    private TreeViewer fTreeViewer;
    private PartnerLinkTypeTreeContentProvider treeContentProvider;
    private PartnerLinkType fPartnerLinkType;

    public PartnerLinkRoleSelectorDialog(Shell shell, EList<Role> list, PartnerLinkType plinkType) {
        super(shell);
        this.fRoles = list;
        this.fPartnerLinkType = plinkType;
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("Roles");
        this.createRadioButton((Composite)group, ((Role)this.fRoles.get(0)).getName(), 0, true);
        this.createRadioButton((Composite)group, ((Role)this.fRoles.get(1)).getName(), 1, false);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        group.setLayoutData((Object)gridData);
        this.createLowerView(composite);
        this.fTreeViewer.setInput((Object)this.fPartnerLinkType);
        return composite;
    }

    protected Button createRadioButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                PartnerLinkRoleSelectorDialog.this.fSelectedRole = (Integer)b.getData();
            }
        });
        return button;
    }

    private Object createLowerView(Composite parent) {
        this.treeContentProvider = new PartnerLinkTypeTreeContentProvider(true);
        this.fTree = new Tree(parent, 2048);
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fTreeViewer.setInput(null);
        this.fTreeViewer.setAutoExpandLevel(5);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 200;
        this.fTree.setLayoutData((Object)data);
        return this.fTree;
    }

    public int getSelectedRole() {
        return this.fSelectedRole;
    }
}

