/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dnd;

import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.commands.AddImportCommand;
import org.eclipse.bpel.ui.dnd.DropPopup;
import org.eclipse.bpel.ui.dnd.Messages;
import org.eclipse.bpel.ui.util.BrowseUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.xsd.XSDSchema;

public class FileDropTargetListener
implements TransferDropTargetListener {
    protected DropPopup fDropPopup;
    protected BPELEditor fEditor;
    StringBuilder fBadDropPaths = new StringBuilder(256);
    int fProssesedGoodDrops = 0;
    int fProssesedBadDrops = 0;

    public FileDropTargetListener(GraphicalViewer viewer, BPELEditor editor) {
        this.fEditor = editor;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
        event.detail = 0;
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.getTransfer().isSupportedType(event.currentDataType)) {
            String[] files = (String[])this.getFileTransfer().nativeToJava(event.dataTypes[0]);
            if (files == null) {
                return;
            }
            this.startImport();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                URI uri = URI.createFileURI((String)f);
                this.addImport(this.attemptLoad(uri), uri);
                ++n2;
            }
            this.endImport(event);
        }
    }

    protected void startImport() {
        this.fProssesedGoodDrops = 0;
        this.fProssesedBadDrops = 0;
        this.fBadDropPaths.setLength(0);
    }

    protected void endImport(DropTargetEvent event) {
        if (this.fProssesedGoodDrops > 0) {
            this.fEditor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileDropTargetListener.this.fEditor.selectModelObject(FileDropTargetListener.this.fEditor.getProcess().getImports());
                }
            });
        }
        if (this.fProssesedBadDrops > 0) {
            this.fEditor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox mb = new MessageBox(FileDropTargetListener.this.fEditor.getSite().getShell(), 34);
                    mb.setText(Messages.FileDropTargetListener_DropProblem);
                    mb.setMessage(NLS.bind((String)Messages.FileDropTargetListener_Message, (Object)FileDropTargetListener.this.fProssesedBadDrops, (Object)FileDropTargetListener.this.fBadDropPaths));
                    mb.open();
                }
            });
        }
    }

    protected void addImport(Object result, URI f) {
        String path = f.path();
        int x = path.lastIndexOf(47);
        if (x > 0) {
            path = path.substring(x + 1);
        }
        if (result == null) {
            ++this.fProssesedBadDrops;
            if (this.fBadDropPaths.length() > 0) {
                this.fBadDropPaths.append(", ");
            }
            this.fBadDropPaths.append(path);
        } else if (result instanceof XSDSchema || result instanceof Definition) {
            AddImportCommand cmd = new AddImportCommand(this.fEditor.getProcess(), result);
            if (cmd.canDoExecute() && !cmd.wouldCreateDuplicateImport()) {
                this.fEditor.getCommandFramework().execute((Command)cmd);
            }
            ++this.fProssesedGoodDrops;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.isEnabled(event)) {
            return;
        }
        event.detail = 0;
    }

    protected Object attemptLoad(URI uri) {
        Resource resource = null;
        ResourceSet editorResourceSet = this.fEditor.getResourceSet();
        try {
            resource = editorResourceSet.getResource(uri, true);
        }
        catch (Throwable t) {
            BPELUIPlugin.log(t);
            return null;
        }
        if (resource.getContents().size() == 0) {
            return null;
        }
        return resource.getContents().get(0);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public FileTransfer getFileTransfer() {
        return (FileTransfer)this.getTransfer();
    }

    public boolean isEnabled(DropTargetEvent event) {
        return this.getTransfer().isSupportedType(event.currentDataType);
    }

    public void execute(String cmd) {
        if ("typeBrowser".equals(cmd)) {
            BrowseUtil.browseForXSDTypeOrElement((EObject)this.fEditor.getProcess(), this.fEditor.getSite().getShell());
        } else if ("wsdlBrowser".equals(cmd)) {
            BrowseUtil.browseForPartnerLinkType((EObject)this.fEditor.getProcess(), this.fEditor.getSite().getShell());
        } else {
            System.out.println("Cmd: " + cmd);
        }
    }
}

