/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.IEventHandlerHolder;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELSelectionEditPolicy;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.bpel.ui.uiextensionmodel.StartNode;
import org.eclipse.bpel.ui.util.BPELDragEditPartsTracker;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Image;

public class StartNodeEditPart
extends BPELEditPart
implements NodeEditPart,
ILayoutAware {
    protected Image image;
    protected int imageWidth;
    protected int imageHeight;
    public static final int BORDER_WIDTH = 8;
    protected boolean hasFH;
    protected boolean hasEH;
    protected boolean showFH = false;
    protected boolean showEH = false;
    protected int faultImageWidth;
    protected int faultImageHeight;
    protected int eventImageWidth;
    protected int eventImageHeight;
    protected Image faultImage = BPELUIPlugin.INSTANCE.getImage("ovr16/faulthandler.gif");
    protected Image eventImage;
    protected org.eclipse.swt.graphics.Rectangle rectFault;
    protected org.eclipse.swt.graphics.Rectangle rectEvent;
    private IFigure faultImageFigure;
    private IFigure eventImageFigure;

    public StartNodeEditPart() {
        org.eclipse.swt.graphics.Rectangle r = this.faultImage.getBounds();
        this.faultImageWidth = r.width;
        this.faultImageHeight = r.height;
        this.eventImage = BPELUIPlugin.INSTANCE.getImage("ovr16/eventhandler.gif");
        r = this.eventImage.getBounds();
        this.eventImageWidth = r.width;
        this.eventImageHeight = r.height;
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        this.adapter.addToObject((Notifier)this.getProcess());
    }

    @Override
    protected void removeAllAdapters() {
        this.adapter.removedFrom(this.getProcess());
        super.removeAllAdapters();
    }

    @Override
    protected IFigure createFigure() {
        if (this.image == null) {
            ILabeledElement element = BPELUtil.adapt((Object)this.getStartNode(), ILabeledElement.class);
            this.image = element.getSmallImage(this.getStartNode());
            org.eclipse.swt.graphics.Rectangle rect = this.image.getBounds();
            this.imageWidth = rect.width;
            this.imageHeight = rect.height;
        }
        this.hasFH = this.getFaultHandler() != null;
        this.hasEH = this.getEventHandler() != null;
        StartNodeFigure snf = new StartNodeFigure();
        if (!ModelHelper.isHorizontalLayout(this.getModel())) {
            snf.setBorder((Border)new MarginBorder(0, 15, 0, 15));
        } else {
            snf.setBorder((Border)new MarginBorder(5, 0, 5, 0));
        }
        this.faultImageFigure = new ImageFigure(this.faultImage);
        this.faultImageFigure.setParent((IFigure)snf);
        this.eventImageFigure = new ImageFigure(this.eventImage);
        this.eventImageFigure.setParent((IFigure)snf);
        return snf;
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        this.hasFH = this.getFaultHandler() != null;
        this.hasEH = this.getEventHandler() != null;
        this.getFigure().repaint();
    }

    public StartNode getStartNode() {
        return (StartNode)this.getModel();
    }

    public Process getProcess() {
        return this.getStartNode().getProcess();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new BPELSelectionEditPolicy(false, false){

            @Override
            protected int getWestInset() {
                Insets ins = ((StartNodeEditPart)this.getHost()).getFigure().getInsets();
                if (ins != null) {
                    return ins.left;
                }
                return super.getWestInset();
            }

            @Override
            protected int getEastInset() {
                Insets ins = ((StartNodeEditPart)this.getHost()).getFigure().getInsets();
                if (ins != null) {
                    return ins.right;
                }
                return super.getEastInset();
            }
        });
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return new CenteredConnectionAnchor(this.getFigure(), 1, 0);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getSourceConnectionAnchor((ConnectionEditPart)null);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getTargetConnectionAnchor((ConnectionEditPart)null);
    }

    public void setShowFaultHandler(boolean showFaultHandler) {
        this.showFH = showFaultHandler;
        ProcessEditPart processEditPart = (ProcessEditPart)this.getParent();
        processEditPart.setShowFaultHandler(showFaultHandler);
        this.refresh();
    }

    public void setShowEventHandler(boolean showEventHandler) {
        this.showEH = showEventHandler;
        ProcessEditPart processEditPart = (ProcessEditPart)this.getParent();
        processEditPart.setShowEventHandler(showEventHandler);
        this.refresh();
    }

    public boolean getShowFaultHandler() {
        return this.showFH;
    }

    public boolean getShowEventHandler() {
        return this.showEH;
    }

    public FaultHandler getFaultHandler() {
        IFaultHandlerHolder holder = BPELUtil.adapt((Object)this.getProcess(), IFaultHandlerHolder.class);
        if (holder != null) {
            return holder.getFaultHandler(this.getProcess());
        }
        return null;
    }

    public EventHandler getEventHandler() {
        IEventHandlerHolder holder = BPELUtil.adapt((Object)this.getProcess(), IEventHandlerHolder.class);
        if (holder != null) {
            return holder.getEventHandler(this.getProcess());
        }
        return null;
    }

    public boolean isPointInFaultImage(int x, int y) {
        if (this.hasFH) {
            Point p = new Point(x, y);
            this.getFigure().translateToRelative((Translatable)p);
            return this.rectFault.contains(p.x, p.y);
        }
        return false;
    }

    public boolean isPointInEventImage(int x, int y) {
        if (this.hasEH) {
            Point p = new Point(x, y);
            this.getFigure().translateToRelative((Translatable)p);
            return this.rectEvent.contains(p.x, p.y);
        }
        return false;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new BPELDragEditPartsTracker((EditPart)this){

            protected boolean handleDoubleClick(int button) {
                return true;
            }

            protected boolean handleButtonDown(int button) {
                Point point = this.getLocation();
                if (StartNodeEditPart.this.isPointInFaultImage(point.x, point.y)) {
                    StartNodeEditPart.this.setShowFaultHandler(!StartNodeEditPart.this.showFH);
                    return true;
                }
                if (StartNodeEditPart.this.isPointInEventImage(point.x, point.y)) {
                    StartNodeEditPart.this.setShowEventHandler(!StartNodeEditPart.this.showEH);
                    return true;
                }
                return super.handleButtonDown(button);
            }
        };
    }

    private void computeHandlerIconPositions(boolean horizontal) {
        Rectangle bounds = this.getFigure().getBounds();
        if (horizontal) {
            this.rectFault = new org.eclipse.swt.graphics.Rectangle(bounds.x, bounds.y + bounds.height - this.faultImageHeight, this.faultImageWidth, this.faultImageHeight);
            this.rectEvent = new org.eclipse.swt.graphics.Rectangle(bounds.x + this.faultImageWidth, bounds.y + bounds.height - this.eventImageHeight, this.eventImageWidth, this.eventImageHeight);
        } else {
            this.rectFault = new org.eclipse.swt.graphics.Rectangle(bounds.x + bounds.width - this.faultImageWidth - 8, bounds.y - 1, this.faultImageWidth, this.faultImageHeight);
            this.rectEvent = new org.eclipse.swt.graphics.Rectangle(bounds.x + bounds.width - this.eventImageWidth - 8, bounds.y + bounds.height - this.eventImageHeight + 1, this.eventImageWidth, this.eventImageHeight);
        }
        this.faultImageFigure.setBounds(new Rectangle(this.rectFault.x, this.rectFault.y, this.rectFault.width, this.rectFault.height));
        this.eventImageFigure.setBounds(new Rectangle(this.rectEvent.x, this.rectEvent.y, this.rectEvent.width, this.rectEvent.height));
    }

    public org.eclipse.swt.graphics.Rectangle getRectFault() {
        return this.rectFault;
    }

    public org.eclipse.swt.graphics.Rectangle getRectEvent() {
        return this.rectEvent;
    }

    @Override
    public void switchLayout(boolean horizontal) {
        if (horizontal) {
            this.getFigure().setBorder((Border)new MarginBorder(5, 0, 5, 0));
        } else {
            this.getFigure().setBorder((Border)new MarginBorder(0, 15, 0, 15));
        }
    }

    public IFigure getFaultImageFigure() {
        return this.faultImageFigure;
    }

    public IFigure getEventImageFigure() {
        return this.eventImageFigure;
    }

    private class StartNodeFigure
    extends ImageFigure {
        public StartNodeFigure() {
            super(StartNodeEditPart.this.image);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            StartNodeEditPart.this.computeHandlerIconPositions(ModelHelper.isHorizontalLayout(StartNodeEditPart.this.getModel()));
            if (StartNodeEditPart.this.hasFH) {
                graphics.pushState();
                graphics.setClip(StartNodeEditPart.this.faultImageFigure.getBounds().getCopy());
                StartNodeEditPart.this.faultImageFigure.paint(graphics);
                graphics.popState();
            }
            if (StartNodeEditPart.this.hasEH) {
                graphics.pushState();
                graphics.setClip(StartNodeEditPart.this.eventImageFigure.getBounds().getCopy());
                StartNodeEditPart.this.eventImageFigure.paint(graphics);
                graphics.popState();
            }
        }
    }
}

