/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util.marker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.decorator.EditPartMarkerDecorator;
import org.eclipse.bpel.common.ui.decorator.IMarkerConstants;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.util.BPELDecorationLayout;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Layer;
import org.eclipse.emf.ecore.EObject;

public class BPELEditPartMarkerDecorator
extends EditPartMarkerDecorator {
    protected List<MarkerMotionListener> listeners = new ArrayList<MarkerMotionListener>();

    public BPELEditPartMarkerDecorator(EObject aModelObject, BPELDecorationLayout decorationLayout) {
        super(aModelObject, null, (AbstractLayout)decorationLayout);
        decorationLayout.addAnchorMotionListener(new BPELDecorationLayout.AnchorMotionListener(){

            @Override
            public void anchorEntered(int position) {
                IMarker[] iMarkerArray = BPELEditPartMarkerDecorator.this.getMarkers();
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int value;
                    IMarker marker = iMarkerArray[n2];
                    Object constraint = BPELEditPartMarkerDecorator.this.getConstraint(marker);
                    if (constraint instanceof Integer && (value = ((Integer)constraint).intValue()) == position) {
                        BPELEditPartMarkerDecorator.this.fireMarkerMotionListeners(marker);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    protected IMarker[] getMarkers() {
        IMarkerHolder holder = BPELUtil.adapt((Object)this.modelObject, IMarkerHolder.class);
        if (holder != null) {
            return holder.getMarkers(this.modelObject);
        }
        return super.getMarkers();
    }

    public void addMarkerMotionListener(MarkerMotionListener listener) {
        this.listeners.add(listener);
    }

    public void removeMarkerMotionListener(MarkerMotionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMarkerMotionListeners(IMarker marker) {
        for (MarkerMotionListener listener : this.listeners) {
            listener.markerEntered(marker);
        }
    }

    public Layer getDecorationLayer() {
        if (this.decorationLayer == null) {
            this.decorationLayer = new Layer();
        }
        return this.decorationLayer;
    }

    protected boolean isAcceptable(IMarker marker) {
        boolean isVisible = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true);
        if (!isVisible) {
            return false;
        }
        String anchorString = marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint", "");
        if (anchorString.equals("DRAWER_BOTTOM") || anchorString.equals("DRAWER_TOP")) {
            return false;
        }
        return super.isAcceptable(marker);
    }

    protected Object getConstraint(IMarker marker) {
        try {
            if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                return IMarkerConstants.BOTTOM_LEFT;
            }
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
        }
        return super.getConstraint(marker);
    }

    protected Object convertAnchorKeyToConstraint(String key) {
        if (key.equals("DRAWER_TOP")) {
            return 64;
        }
        if (key.equals("DRAWER_BOTTOM")) {
            return 128;
        }
        return super.convertAnchorKeyToConstraint(key);
    }

    public static interface MarkerMotionListener {
        public void markerEntered(IMarker var1);
    }
}

