/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapraNotificationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CapraNotificationHelper.class);
    public static final String CAPRA_PROBLEM_MARKER_ID = "org.eclipse.capra.ui.notification.capraProblemMarker";
    public static final String NOTIFICATION_JOB = "CapraNotificationJob";
    public static final String ISSUE_TYPE = "issueType";
    public static final String OLD_URI = "oldArtifactUri";
    public static final String NEW_URI = "newArtifactUri";
    public static final String NEW_NAME = "newArtifactName";
    public static final String MESSAGE = "message";

    private CapraNotificationHelper() {
    }

    public static void createCapraMarker(Map<String, String> markerInfo, IFile container) {
        block9: {
            try {
                String newMarkerIssue = markerInfo.get(ISSUE_TYPE);
                String newMarkerUri = markerInfo.get(OLD_URI);
                IMarker[] existingMarkers = container.findMarkers(CAPRA_PROBLEM_MARKER_ID, false, 0);
                IMarker[] iMarkerArray = existingMarkers;
                int n = existingMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker existingMarker = iMarkerArray[n2];
                    String existingMarkerIssue = existingMarker.getAttribute(ISSUE_TYPE, null);
                    String existingMarkerUri = existingMarker.getAttribute(OLD_URI, null);
                    if (existingMarkerUri != null && existingMarkerIssue != null) {
                        if (existingMarkerUri.equals(newMarkerUri) && existingMarkerIssue.equals(newMarkerIssue)) {
                            existingMarker.delete();
                        }
                        if (existingMarkerUri.equals(newMarkerUri) && existingMarkerIssue.equals(IssueType.DELETED.getValue()) && newMarkerIssue.matches(String.valueOf(IssueType.RENAMED.getValue()) + "|" + IssueType.MOVED.getValue())) {
                            existingMarker.delete();
                        }
                        if (existingMarkerUri.equals(newMarkerUri) && newMarkerIssue.equalsIgnoreCase(IssueType.ADDED.getValue())) {
                            existingMarker.delete();
                        }
                    }
                    ++n2;
                }
                String message = markerInfo.get(MESSAGE);
                if (message == null || message.isEmpty()) {
                    return;
                }
                IMarker marker = container.createMarker(CAPRA_PROBLEM_MARKER_ID);
                marker.setAttribute("severity", 1);
                marker.setAttribute(MESSAGE, (Object)message);
                markerInfo.remove(MESSAGE);
                for (Map.Entry entry : markerInfo.entrySet()) {
                    marker.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            catch (CoreException e) {
                if (!container.exists()) break block9;
                LOG.warn("CoreException occured when creating a marker even though container exists.", (Throwable)e);
            }
        }
    }

    public static void deleteCapraMarker(String uri, IssueType[] issues, IFile containingFile) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = containingFile.findMarkers(CAPRA_PROBLEM_MARKER_ID, true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String existingMarkerUri = marker.getAttribute(OLD_URI, null);
                String existingMarkerIssue = marker.getAttribute(ISSUE_TYPE, null);
                if (existingMarkerUri.equals(uri)) {
                    if (issues == null) {
                        marker.delete();
                    } else {
                        IssueType[] issueTypeArray = issues;
                        int n3 = issues.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IssueType issue = issueTypeArray[n4];
                            if (existingMarkerIssue.equals(issue.getValue())) {
                                marker.delete();
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LOG.warn("CoreException occured when deleting a marker.", (Throwable)e);
        }
    }

    public static URI convertToFileUri(URI uri) {
        if (!uri.isPlatformResource()) {
            return uri;
        }
        String platformUri = uri.toPlatformString(true);
        IPath filePath = ResourcesPlugin.getWorkspace().getRoot().findMember(platformUri).getRawLocation();
        URI fileUri = URI.createFileURI((String)filePath.toString());
        String fragment = uri.fragment();
        if (fragment != null) {
            fileUri = fileUri.appendFragment(fragment);
        }
        return fileUri;
    }

    public static URI getFileUri(EObject eObject) {
        return CapraNotificationHelper.convertToFileUri(EcoreUtil.getURI((EObject)eObject));
    }

    public static URI getFileUri(Resource resource) {
        return CapraNotificationHelper.convertToFileUri(resource.getURI());
    }

    public static enum IssueType {
        RENAMED("renamed"),
        MOVED("moved"),
        DELETED("deleted"),
        CHANGED("changed"),
        ADDED("added");

        private final String value;

        private IssueType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

