/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IMarkerResolution;

public class DeleteQuickFix
implements IMarkerResolution {
    ArtifactMetaModelAdapter artifactAdapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().orElseThrow();
    private String label;

    DeleteQuickFix(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        ArrayList<Connection> toDelete = new ArrayList<Connection>();
        ArrayList<Connection> toRecreate = new ArrayList<Connection>();
        EObject artifactToDelete = null;
        TracePersistenceAdapter tracePersistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject traceModel = tracePersistenceAdapter.getTraceModel(resourceSet);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        TraceMetaModelAdapter traceMetamodelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().orElseThrow();
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers(resourceSet);
        List artifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
        String artifactContainerFileName = artifactModel.eResource().getURI().lastSegment();
        String markerContainerFileName = new File(marker.getResource().toString()).getName();
        String markerUri = marker.getAttribute("oldArtifactUri", null);
        if (markerContainerFileName.equals(artifactContainerFileName)) {
            for (EObject aw : artifacts) {
                if (!this.artifactAdapter.getArtifactUri(aw).equals(markerUri)) continue;
                List traceLinks = traceMetamodelAdapter.getConnectedElements(aw, traceModel);
                for (Connection con : traceLinks) {
                    if (traceHelper.getTracedElements(con).size() == 2) {
                        toDelete.add(con);
                        continue;
                    }
                    toRecreate.add(con);
                }
                artifactToDelete = aw;
                break;
            }
            traceMetamodelAdapter.deleteTrace(toDelete, traceModel);
            EcoreUtil.delete(artifactToDelete);
            this.recreateTrace(toRecreate, traceModel);
            tracePersistenceAdapter.saveTracesAndArtifacts(traceModel, artifactModel);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            for (Connection c : traceMetamodelAdapter.getAllTraceLinks(traceModel)) {
                if (traceHelper.getTracedElements(c).size() >= 2) continue;
                toDelete.add(c);
            }
            traceMetamodelAdapter.deleteTrace(toDelete, traceModel);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void recreateTrace(List<Connection> toRecreate, EObject traceModel) {
        TraceMetaModelAdapter traceMetaModelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().orElseThrow();
        for (Connection c : toRecreate) {
            traceMetaModelAdapter.createTrace(c.getTlink().eClass(), traceModel, c.getOrigins(), c.getTargets());
        }
        traceMetaModelAdapter.deleteTrace(toRecreate, traceModel);
    }
}

