/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.xtext.selections;

import java.util.Collections;
import java.util.List;
import org.eclipse.capra.ui.selections.ISelectionSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtextEditorSelectionSupport
implements ISelectionSupport {
    private final EObjectAtOffsetHelper eObjectOffsetHelper = new EObjectAtOffsetHelper();

    public boolean supportsWorkbenchPart(IWorkbenchPart workbenchPart) {
        return workbenchPart instanceof XtextEditor;
    }

    public List<Object> extractSelectedElements(ISelection selection, IWorkbenchPart workbenchPart) {
        if (selection instanceof ITextSelection) {
            ITextSelection textselection;
            XtextResource resource = this.getResource(workbenchPart);
            EObject selectedElement = this.eObjectOffsetHelper.resolveElementAt(resource, (textselection = (ITextSelection)selection).getOffset());
            if (selectedElement == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(selectedElement);
        }
        return Collections.emptyList();
    }

    protected XtextResource getResource(IWorkbenchPart workbenchPart) {
        IXtextDocument document = XtextDocumentUtil.get((Object)workbenchPart);
        if (document == null) {
            return null;
        }
        return (XtextResource)document.readOnly((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

            public XtextResource exec(XtextResource state) throws Exception {
                return state;
            }
        });
    }

    public ResourceSet getResourceSet(IWorkbenchPart workbenchPart) {
        XtextResource resource = this.getResource(workbenchPart);
        return resource == null ? null : resource.getResourceSet();
    }
}

