/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryLoginHandler;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public abstract class ClientRequest<T>
extends BaseClientRequest<T> {
    public ClientRequest(String label) {
        super(label);
    }

    @Override
    protected T runAndWait(CloudFoundryOperations client, SubMonitor subProgress) throws CoreException {
        try {
            return super.runAndWait(client, subProgress);
        }
        catch (CoreException ce) {
            CloudFoundryLoginHandler handler = new CloudFoundryLoginHandler(client);
            CoreException accessError = null;
            String accessErrorMessage = null;
            if (handler.shouldAttemptClientLogin(ce)) {
                CloudFoundryPlugin.logWarning(NLS.bind((String)Messages.ClientRequest_RETRY_REQUEST, (Object)this.getTokenAccessErrorLabel()));
                accessError = ce;
                int attempts = 3;
                OAuth2AccessToken token = handler.login((IProgressMonitor)subProgress, attempts, 2000L);
                if (token == null) {
                    accessErrorMessage = Messages.ClientRequest_NO_TOKEN;
                } else if (token.isExpired()) {
                    accessErrorMessage = Messages.ClientRequest_TOKEN_EXPIRED;
                } else {
                    try {
                        return super.runAndWait(client, subProgress);
                    }
                    catch (CoreException e) {
                        accessError = e;
                    }
                }
            }
            if (accessError != null) {
                Throwable cause;
                Throwable throwable = cause = accessError.getCause() != null ? accessError.getCause() : accessError;
                if (accessErrorMessage == null) {
                    accessErrorMessage = accessError.getMessage();
                }
                accessErrorMessage = NLS.bind((String)Messages.ClientRequest_SECOND_ATTEMPT_FAILED, (Object)this.getTokenAccessErrorLabel(), (Object)accessErrorMessage);
                throw CloudErrorUtil.toCoreException(accessErrorMessage, cause);
            }
            throw ce;
        }
    }

    protected String getTokenAccessErrorLabel() {
        return this.getRequestLabel();
    }
}

