/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.service.prefs.BackingStoreException;

public class ModuleCache {
    static final String KEY_MODULE_MAPPING_LIST = "org.eclipse.cft.moduleMapping";
    private Map<IServer, ServerData> dataByServer;
    private IServerLifecycleListener listener = new IServerLifecycleListener(){

        public void serverAdded(IServer server) {
        }

        public void serverChanged(IServer server) {
        }

        public void serverRemoved(IServer server) {
            ModuleCache.this.remove(server);
        }
    };

    public ModuleCache() {
        this.dataByServer = new HashMap<IServer, ServerData>();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.listener);
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.listener);
    }

    public synchronized ServerData getData(IServer server) {
        ServerData data = this.dataByServer.get(server);
        if (data == null && server != null) {
            data = new ServerData(server);
            this.dataByServer.put(server, data);
        }
        return data;
    }

    protected synchronized void remove(IServer server) {
        this.dataByServer.remove(server);
        CloudFoundryServer cfs = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
        String serverId = cfs.getServerId();
        if (serverId != null) {
            IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.cft.server.core");
            node.remove("org.eclipse.cft.moduleMapping:" + serverId);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to remove application mappings", (Throwable)e));
            }
        }
    }

    public static class ServerData {
        private final List<CloudFoundryApplicationModule> cloudModules = new ArrayList<CloudFoundryApplicationModule>();
        private String password;
        private String token;
        private IServer server;
        private final List<IModule> undeployedModules = new ArrayList<IModule>();
        private final Map<String, CloudFoundryApplicationModule> mapProject = new HashMap<String, CloudFoundryApplicationModule>();
        private int[] applicationMemoryChoices;

        ServerData(IServer server) {
            this.server = server;
        }

        public synchronized void clear() {
            this.cloudModules.clear();
        }

        public synchronized CloudFoundryApplicationModule createModule(CloudApplication application) {
            CloudFoundryApplicationModule appModule = new CloudFoundryApplicationModule(application.getName(), this.server);
            appModule.setCloudApplication(application);
            this.add(appModule);
            return appModule;
        }

        public synchronized void updateCloudApplicationModule(CloudFoundryApplicationModule module) {
            if (module.getLocalModule() != null) {
                Map<String, String> mapping = this.getLocalModuleToCloudModuleMapping();
                mapping.put(module.getLocalModule().getId(), module.getDeployedApplicationName());
                this.setLocalModuleToCloudModuleMapping(mapping);
            }
        }

        public synchronized Collection<CloudFoundryApplicationModule> getExistingCloudModules() {
            return new ArrayList<CloudFoundryApplicationModule>(this.cloudModules);
        }

        public synchronized String getPassword() {
            return this.password;
        }

        public synchronized String getToken() {
            return this.token;
        }

        public synchronized boolean isUndeployed(IModule module) {
            return this.undeployedModules.contains(module);
        }

        public synchronized void remove(CloudFoundryApplicationModule module) {
            if (module == null) {
                return;
            }
            this.cloudModules.remove(module);
            if (module.getLocalModule() != null) {
                Map<String, String> mapping = this.getLocalModuleToCloudModuleMapping();
                mapping.remove(module.getLocalModule().getId());
                this.setLocalModuleToCloudModuleMapping(mapping);
            }
        }

        public synchronized void removeObsoleteModules(Set<CloudFoundryApplicationModule> allModules) {
            HashSet<CloudFoundryApplicationModule> deletedModules = new HashSet<CloudFoundryApplicationModule>(this.cloudModules);
            deletedModules.removeAll(allModules);
            if (deletedModules.size() > 0) {
                Map<String, String> mapping = this.getLocalModuleToCloudModuleMapping();
                boolean mappingModified = false;
                for (CloudFoundryApplicationModule deletedModule : deletedModules) {
                    if (deletedModule.getLocalModule() == null) continue;
                    mappingModified |= mapping.remove(deletedModule.getLocalModule().getId()) != null;
                }
                if (mappingModified) {
                    this.setLocalModuleToCloudModuleMapping(mapping);
                }
            }
        }

        public synchronized void setPassword(String password) {
            this.password = password;
        }

        public synchronized void setToken(String token) {
            this.token = token;
        }

        public synchronized void tagAsDeployed(IModule module) {
            this.undeployedModules.remove(module);
        }

        public synchronized void tagAsUndeployed(IModule module) {
            this.undeployedModules.add(module);
        }

        public synchronized void tagForReplace(CloudFoundryApplicationModule appModule) {
            if (appModule != null) {
                this.mapProject.put(appModule.getDeployedApplicationName(), appModule);
            }
        }

        public synchronized void untagForReplace(CloudFoundryApplicationModule appModule) {
            if (appModule != null) {
                this.mapProject.remove(appModule.getDeployedApplicationName());
            }
        }

        public synchronized CloudFoundryApplicationModule getTaggedForReplace(CloudFoundryApplicationModule appModule) {
            return appModule != null ? this.mapProject.get(appModule.getDeployedApplicationName()) : null;
        }

        private void add(CloudFoundryApplicationModule module) {
            this.cloudModules.add(module);
        }

        private String convertMapToString(Map<String, String> map) {
            if (map == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.append(entry.getKey());
                result.append(",");
                result.append(entry.getValue());
                result.append(",");
            }
            return result.toString();
        }

        private Map<String, String> convertStringToMap(String str) {
            if (str == null) {
                return new HashMap<String, String>();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            String[] tokens = str.split(",");
            int i = 0;
            while (i < tokens.length - 1) {
                result.put(tokens[i], tokens[i + 1]);
                i += 2;
            }
            return result;
        }

        private Map<String, String> getLocalModuleToCloudModuleMapping() {
            IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.cft.server.core");
            String string = node.get("org.eclipse.cft.moduleMapping:" + this.getServerId(), "");
            return this.convertStringToMap(string);
        }

        private CloudFoundryApplicationModule getCloudModuleByDeployedAppName(String deployedApplicationName) {
            for (CloudFoundryApplicationModule module : this.cloudModules) {
                if (!deployedApplicationName.equals(module.getDeployedApplicationName())) continue;
                return module;
            }
            return null;
        }

        private CloudFoundryApplicationModule getCloudModuleToLocalModuleName(String localName) {
            for (CloudFoundryApplicationModule module : this.cloudModules) {
                if (!localName.equals(module.getName())) continue;
                return module;
            }
            return null;
        }

        private String getServerId() {
            CloudFoundryServer cfs = (CloudFoundryServer)((Object)this.server.loadAdapter(CloudFoundryServer.class, null));
            return cfs.getServerId();
        }

        private void setLocalModuleToCloudModuleMapping(Map<String, String> list) {
            String string = this.convertMapToString(list);
            IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.cft.server.core");
            CloudFoundryPlugin.trace("Updated mapping: " + string);
            node.put("org.eclipse.cft.moduleMapping:" + this.getServerId(), string);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to update application mappings", (Throwable)e));
            }
        }

        synchronized CloudFoundryApplicationModule getExistingCloudModule(IModule module) {
            if (module == null) {
                return null;
            }
            CloudFoundryApplicationModule appModule = this.getCloudModuleToLocalModuleName(module.getName());
            if (appModule != null) {
                return appModule;
            }
            String deployedAppName = this.getLocalModuleToCloudModuleMapping().get(module.getId());
            if (deployedAppName != null && (appModule = this.getCloudModuleByDeployedAppName(deployedAppName)) != null) {
                return appModule;
            }
            return null;
        }

        synchronized CloudFoundryApplicationModule getOrCreateCloudModule(IModule module) {
            CloudFoundryApplicationModule appModule = this.getExistingCloudModule(module);
            if (appModule != null) {
                return appModule;
            }
            String deployedAppName = this.getLocalModuleToCloudModuleMapping().get(module.getId());
            if (deployedAppName == null) {
                deployedAppName = module.getName();
            }
            appModule = new CloudFoundryApplicationModule(module, deployedAppName, this.server);
            this.add(appModule);
            return appModule;
        }

        void updateServerId(String oldServerId, String newServerId) {
            IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.cft.server.core");
            String string = node.get("org.eclipse.cft.moduleMapping:" + oldServerId, "");
            node.remove("org.eclipse.cft.moduleMapping:" + oldServerId);
            node.put("org.eclipse.cft.moduleMapping:" + newServerId, string);
        }

        public synchronized void setApplicationMemoryChoices(int[] applicationMemoryChoices) {
            this.applicationMemoryChoices = applicationMemoryChoices;
        }

        public synchronized int[] getApplicationMemoryChoices() {
            return this.applicationMemoryChoices;
        }
    }
}

