/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class WizardStatusHandler
implements IPartChangeListener {
    @Override
    public void handleChange(PartChangeEvent event) {
        IStatus status = event != null ? event.getStatus() : null;
        this.handleChange(status);
    }

    public void handleChange(IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        this.setWizardError(null);
        if (status.getSeverity() == 1) {
            this.setWizardInformation(status.getMessage());
        } else if (status.getSeverity() == 4) {
            this.setWizardError(status.getMessage());
        } else if (status.getSeverity() == 0 && !Status.OK_STATUS.getMessage().equals(status.getMessage())) {
            this.setWizardMessage(status.getMessage());
        }
        this.update();
    }

    protected abstract void update();

    protected abstract void setWizardError(String var1);

    protected abstract void setWizardInformation(String var1);

    protected abstract void setWizardMessage(String var1);
}

