/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;

public class FWLogger {
    private static final FWLogger instance = new FWLogger();
    private final LogLevel level;
    private final LogLevel DEFAULT_LOG_LEVEL = LogLevel.INFO;
    private final SimpleDateFormat PRETTY_DATE_FORMAT = new SimpleDateFormat("MMM d h:mm:ss.SSS a");
    private static final boolean printCallingMethods = false;
    private final long startTimeInNanos = System.nanoTime();
    private RollingFileLogger fileLogger_synch_lock = null;
    private boolean outputLogsToScreen = true;
    private final Object lock = new Object();

    private FWLogger() {
        LogLevel newLogLevel = this.DEFAULT_LOG_LEVEL;
        block0: for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            if (!e.getKey().equalsIgnoreCase("filewatcher_log_level")) continue;
            for (LogLevel en : LogLevel.values()) {
                if (!en.name().equalsIgnoreCase(e.getValue())) continue;
                newLogLevel = en;
                break block0;
            }
        }
        this.level = newLogLevel;
        this.out("Logging at log level: " + this.level.name());
    }

    public static FWLogger getInstance() {
        return instance;
    }

    public void setOutputLogsToScreen(boolean outputLogsToSecreen) {
        this.outputLogsToScreen = outputLogsToSecreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollingFileLoggerOutputDir(File outputDir) {
        Object object = this.lock;
        synchronized (object) {
            if (this.fileLogger_synch_lock == null) {
                this.fileLogger_synch_lock = new RollingFileLogger(outputDir, this);
                this.fileLogger_synch_lock.start();
            }
        }
    }

    private final String time() {
        long time = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startTimeInNanos, TimeUnit.NANOSECONDS);
        long seconds = time / 1000L;
        long msecs = time % 1000L;
        String msecsStr = Long.toString(msecs);
        while (msecsStr.length() < 3) {
            msecsStr = "0" + msecsStr;
        }
        return this.PRETTY_DATE_FORMAT.format(new Date()) + " [" + seconds + "." + msecsStr + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void out(String str) {
        String callingMethod = "";
        String output = this.time() + " " + str + callingMethod;
        if (this.outputLogsToScreen) {
            System.out.println(output);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fileLogger_synch_lock != null) {
                this.fileLogger_synch_lock.addOut(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void err(String str) {
        String callingMethod = "";
        String output = this.time() + " " + str + callingMethod;
        if (this.outputLogsToScreen) {
            System.err.println(output);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fileLogger_synch_lock != null) {
                this.fileLogger_synch_lock.addErr(output);
            }
        }
    }

    public boolean isDebug() {
        return this.level == LogLevel.DEBUG;
    }

    public void logDebug(String msg) {
        if (this.level != LogLevel.DEBUG) {
            return;
        }
        this.out(msg);
    }

    public void logDebug(String msg, String projectId) {
        if (this.level != LogLevel.DEBUG) {
            return;
        }
        if (projectId != null) {
            this.out(msg + " [project-id:" + projectId + "]");
        } else {
            this.out(msg);
        }
    }

    public void logInfo(String msg) {
        if (this.level == LogLevel.ERROR || this.level == LogLevel.SEVERE) {
            return;
        }
        this.out(msg);
    }

    public void logInfo(String msg, String projectId) {
        if (this.level == LogLevel.ERROR || this.level == LogLevel.SEVERE) {
            return;
        }
        if (projectId != null) {
            this.out(msg + " [project-id:" + projectId + "]");
        } else {
            this.out(msg);
        }
    }

    public void logError(String msg) {
        this.logError(msg, null);
    }

    public void logError(String msg, Throwable t) {
        if (this.level == LogLevel.SEVERE) {
            return;
        }
        String outputMsg = "! ERROR ! " + msg;
        if (t != null) {
            outputMsg = outputMsg + " " + FilewatcherUtils.convertStackTraceToString(t);
        }
        this.err(outputMsg);
    }

    public void logSevere(String msg) {
        this.logSevere(msg, null, null);
    }

    public void logSevere(String msg, Throwable t, String projectId) {
        String outputMsg = "!!! SEVERE !!! " + msg;
        if (t != null) {
            outputMsg = outputMsg + " " + FilewatcherUtils.convertStackTraceToString(t);
        }
        this.err(outputMsg);
    }

    private static String getCallingMethod(Class<?> loggerClass) {
        String loggerClassName = loggerClass.getName();
        try {
            StackTraceElement[] steList = Thread.currentThread().getStackTrace();
            int lastIndexOfLoggerClass = -1;
            for (int x = 0; x < steList.length; ++x) {
                StackTraceElement ste = steList[x];
                if (ste.getClassName() == null || !ste.getClassName().equals(loggerClassName)) continue;
                lastIndexOfLoggerClass = x;
            }
            if (lastIndexOfLoggerClass != -1 && lastIndexOfLoggerClass + 1 < steList.length) {
                StackTraceElement result = steList[lastIndexOfLoggerClass + 1];
                String resultClassName = result.getClassName();
                int index = resultClassName.lastIndexOf(".");
                if (index != -1) {
                    resultClassName = resultClassName.substring(index + 1);
                }
                return "[" + resultClassName + "." + result.getMethodName() + ":" + result.getLineNumber() + "] ";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static class RollingFileLogger
    extends Thread {
        private final File logDir;
        private List<FileLoggerEntry> entries_synch_lock = new ArrayList<FileLoggerEntry>();
        private final Object lock = new Object();
        private final String FILE_PREFIX = "filewatcherd-";
        private final String FILE_SUFFIX = ".log";
        private final long MAX_LOG_FILE_SIZE = 0xC00000L;
        private final FWLogger parent;

        public RollingFileLogger(File logDir, FWLogger parent) {
            this.setName(this.getClass().getName());
            this.setDaemon(true);
            this.logDir = logDir;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.addOut("Logging at log level: " + this.parent.level.name());
            String EOL = System.lineSeparator();
            while (!this.logDir.exists()) {
                FilewatcherUtils.sleepIgnoreInterrupt(1000L);
                Object object = this.lock;
                synchronized (object) {
                    this.entries_synch_lock.clear();
                }
            }
            Arrays.asList(this.logDir.listFiles()).stream().filter(e -> e.getName().startsWith("filewatcherd-") && e.getName().endsWith(".log")).forEach(e -> {
                if (!e.delete()) {
                    System.err.println("Unable to delete old log file: " + e.getPath());
                }
            });
            int currNumber = 0;
            OutputStreamWriter fw = null;
            long charsLogged = 0L;
            ArrayList<FileLoggerEntry> entries = new ArrayList<FileLoggerEntry>();
            while (true) {
                if (fw == null) {
                    try {
                        charsLogged = 0L;
                        File toDelete = new File(this.logDir, "filewatcherd-" + (++currNumber - 2) + ".log");
                        if (toDelete.exists()) {
                            toDelete.delete();
                        }
                        fw = new FileWriter(new File(this.logDir, "filewatcherd-" + currNumber + ".log"));
                    }
                    catch (IOException e1) {
                        fw = null;
                    }
                }
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    try {
                        this.lock.wait();
                        entries.addAll(this.entries_synch_lock);
                        this.entries_synch_lock.clear();
                    }
                    catch (InterruptedException e2) {
                        FilewatcherUtils.sleepIgnoreInterrupt(100L);
                    }
                }
                if (entries.size() <= 0) continue;
                try {
                    for (FileLoggerEntry e3 : entries) {
                        fw.write(e3.msg + EOL);
                        charsLogged += (long)e3.msg.length();
                    }
                    fw.flush();
                    if (charsLogged > 0xC00000L) {
                        fw.close();
                        fw = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                entries.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOut(String msg) {
            Object object = this.lock;
            synchronized (object) {
                this.entries_synch_lock.add(new FileLoggerEntry(FileLoggerEntry.Type.OUT, msg));
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addErr(String msg) {
            Object object = this.lock;
            synchronized (object) {
                this.entries_synch_lock.add(new FileLoggerEntry(FileLoggerEntry.Type.ERR, msg));
                this.lock.notify();
            }
        }

        private static class FileLoggerEntry {
            private final String msg;
            private final Type type;

            public FileLoggerEntry(Type type, String msg) {
                this.msg = msg;
                this.type = type;
            }

            static enum Type {
                OUT,
                ERR;

            }
        }
    }

    private static enum LogLevel {
        DEBUG,
        INFO,
        ERROR,
        SEVERE;

    }
}

