/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.BuildStatus;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class StartBuildAction
implements IObjectActionDelegate {
    protected CodewindApplication app;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            if (this.app.isAvailable() && this.app.getBuildStatus() != BuildStatus.IN_PROGRESS && this.app.getBuildStatus() != BuildStatus.QUEUED) {
                action.setEnabled(true);
                return;
            }
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)"StartBuildAction ran but no application was selected");
            return;
        }
        try {
            this.app.connection.requestProjectBuild(this.app, "build");
        }
        catch (Exception e) {
            Logger.logError((String)("Error requesting build for application: " + this.app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)NLS.bind((String)Messages.StartBuildError, (Object)this.app.name), (String)e.getMessage());
            return;
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

