/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectWizard;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionProviderAction;

public class NewProjectAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public NewProjectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.NewProjectAction_Label);
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"NewProjectAction ran but no connection was selected");
            return;
        }
        try {
            List templates = this.connection.requestProjectTemplates(true);
            NewCodewindProjectWizard wizard = new NewCodewindProjectWizard(this.connection, templates);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            if (dialog.open() == 1) {
                return;
            }
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred running the new project action on connection: " + this.connection.getBaseURI()), (Throwable)e);
        }
    }
}

