/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.IDebugLauncher;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.ui.internal.debug.NodeJSDebugLauncher;
import org.eclipse.codewind.ui.internal.views.UpdateHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CodewindUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.codewind.ui";
    private static URL ICON_BASE_URL;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();
    private UpdateHandler updateHandler;
    public static final String ICON_BASE_PATH = "icons/";
    public static final String CODEWIND_ICON = "codewind.png";
    public static final String CODEWIND_BANNER = "codewindBanner.png";
    public static final String ERROR_ICON_PATH = "error.png";
    public static final String OPEN_APP_ICON = "elcl16/open_app.png";
    public static final String BUILD_ICON = "elcl16/build_exec.png";
    public static final String IMPORT_ICON = "elcl16/import_wiz.png";
    public static final String LAUNCH_DEBUG_ICON = "elcl16/debug_exc.png";
    public static final String LAUNCH_RUN_ICON = "elcl16/run_exc.png";
    public static final String REFRESH_ICON = "elcl16/refresh.png";
    public static final String CLOUD_ICON = "obj16/cloud.png";
    public static final String GO_ICON = "obj16/go.png";
    public static final String JAVA_ICON = "obj16/java.png";
    public static final String MICROPROFILE_ICON = "obj16/microprofile.png";
    public static final String NODE_ICON = "obj16/nodejs.png";
    public static final String PYTHON_ICON = "obj16/python.png";
    public static final String SPRING_ICON = "obj16/spring.png";
    public static final String SWIFT_ICON = "obj16/swift.png";
    public static final String PROJECTS_ICON = "obj16/projects.png";
    private static CodewindUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.updateHandler = new UpdateHandler();
        CodewindCorePlugin.setUpdateHandler((IUpdateHandler)this.updateHandler);
        CodewindCorePlugin.addDebugLauncher((ProjectLanguage)ProjectLanguage.LANGUAGE_NODEJS, (IDebugLauncher)new NodeJSDebugLauncher());
    }

    public void stop(BundleContext context) throws Exception {
        this.updateHandler = null;
        CodewindCorePlugin.setUpdateHandler(null);
        plugin = null;
        super.stop(context);
    }

    public static CodewindUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL url = CodewindUIPlugin.getDefault().getBundle().getEntry(ICON_BASE_PATH + path);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static ImageDescriptor getDefaultIcon() {
        return CodewindUIPlugin.getImageDescriptor(CODEWIND_ICON);
    }

    public static Image getImage(String key) {
        return plugin.getImageRegistry().get(key);
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry();
        if (ICON_BASE_URL == null) {
            ICON_BASE_URL = plugin.getBundle().getEntry(ICON_BASE_PATH);
        }
        this.registerImage(registry, CODEWIND_ICON, ICON_BASE_URL + CODEWIND_ICON);
        this.registerImage(registry, CODEWIND_BANNER, ICON_BASE_URL + CODEWIND_BANNER);
        this.registerImage(registry, OPEN_APP_ICON, ICON_BASE_URL + OPEN_APP_ICON);
        this.registerImage(registry, BUILD_ICON, ICON_BASE_URL + BUILD_ICON);
        this.registerImage(registry, IMPORT_ICON, ICON_BASE_URL + IMPORT_ICON);
        this.registerImage(registry, LAUNCH_DEBUG_ICON, ICON_BASE_URL + LAUNCH_DEBUG_ICON);
        this.registerImage(registry, LAUNCH_RUN_ICON, ICON_BASE_URL + LAUNCH_RUN_ICON);
        this.registerImage(registry, REFRESH_ICON, ICON_BASE_URL + REFRESH_ICON);
        this.registerImage(registry, CLOUD_ICON, ICON_BASE_URL + CLOUD_ICON);
        this.registerImage(registry, GO_ICON, ICON_BASE_URL + GO_ICON);
        this.registerImage(registry, JAVA_ICON, ICON_BASE_URL + JAVA_ICON);
        this.registerImage(registry, MICROPROFILE_ICON, ICON_BASE_URL + MICROPROFILE_ICON);
        this.registerImage(registry, NODE_ICON, ICON_BASE_URL + NODE_ICON);
        this.registerImage(registry, PYTHON_ICON, ICON_BASE_URL + PYTHON_ICON);
        this.registerImage(registry, SPRING_ICON, ICON_BASE_URL + SPRING_ICON);
        this.registerImage(registry, SWIFT_ICON, ICON_BASE_URL + SWIFT_ICON);
        this.registerImage(registry, PROJECTS_ICON, ICON_BASE_URL + PROJECTS_ICON);
        return registry;
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Logger.logError((String)"Error registering image", (Throwable)e);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return CodewindCorePlugin.getDefault().getPreferenceStore();
    }

    public static UpdateHandler getUpdateHandler() {
        return CodewindUIPlugin.getDefault().updateHandler;
    }
}

