/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.connection;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindApplicationFactory;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.HttpUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.AuthToken;
import org.eclipse.codewind.intellij.core.cli.CLIUtil;
import org.eclipse.codewind.intellij.core.cli.InstallUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnectionException;
import org.eclipse.codewind.intellij.core.connection.CodewindSocket;
import org.eclipse.codewind.intellij.core.connection.ConnectionEnv;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.eclipse.codewind.intellij.core.connection.ProjectTypeInfo;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;
import org.eclipse.codewind.intellij.core.filewatcher.CodewindIntelliJFilewatcherdConnection;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CodewindConnection {
    private static final Pattern RELEASE_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");
    private String name;
    private URI baseUri;
    private String conid;
    private AuthToken authToken;
    private ConnectionEnv env = null;
    private String connectionErrorMsg = null;
    private CodewindSocket socket;
    private CodewindIntelliJFilewatcherdConnection filewatcher;
    private volatile boolean isConnected = false;
    private final Map<String, CodewindApplication> appMap = new LinkedHashMap<String, CodewindApplication>();

    public CodewindConnection(String name, URI uri, String conid) {
        this.setName(name);
        this.setBaseURI(uri);
        this.conid = conid;
    }

    public void connect() throws IOException, JSONException {
        if (this.isConnected) {
            return;
        }
        if (!this.waitForReady()) {
            Logger.logWarning("Timed out waiting for Codewind to go into ready state.");
            this.onInitFail(CodewindCoreBundle.message("Connection_ErrConnection_CodewindNotReady", new Object[0]));
        }
        this.env = new ConnectionEnv(CodewindConnection.getEnvData(this.baseUri, this.authToken));
        if (this.isLocal()) {
            Logger.log("Codewind version is: " + this.env.getVersion());
            if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
                Logger.logWarning("The detected version of Codewind is not supported: " + this.env.getVersion() + ", url: " + this.baseUri);
                this.onInitFail(CodewindCoreBundle.message("Connection_ErrConnection_OldVersion", this.env.getVersion(), InstallUtil.getVersion()));
            }
        }
        this.socket = new CodewindSocket(this, this.authToken);
        if (!this.socket.blockUntilFirstConnection()) {
            Logger.logWarning("Socket failed to connect: " + this.socket.socketUri);
            this.disconnect();
            throw new CodewindConnectionException(this.socket.socketUri);
        }
        File cwctl = new File(CLIUtil.getCWCTLExecutable());
        this.filewatcher = new CodewindIntelliJFilewatcherdConnection(this.baseUri.toString(), cwctl, null);
        this.isConnected = true;
        Logger.log("Connected to: " + this);
        this.refreshApps(null);
    }

    public static LocalConnection createLocalConnection() {
        return new LocalConnection(null);
    }

    public String getSocketNamespace() {
        return this.env.getSocketNamespace();
    }

    public CodewindSocket getSocket() {
        return this.socket;
    }

    private void onInitFail(String msg) throws ConnectException {
        Logger.log("Initializing Codewind connection failed: " + msg);
        this.disconnect();
        throw new ConnectException(msg);
    }

    public void disconnect() {
        Logger.log("Disconnecting connection: " + this);
        this.isConnected = false;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.filewatcher != null) {
            this.filewatcher.dispose();
        }
        for (CodewindApplication app : this.appMap.values()) {
            app.dispose();
        }
        this.appMap.clear();
    }

    public void close() {
        this.disconnect();
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URI getBaseURI() {
        return this.baseUri;
    }

    public void setBaseURI(URI uri) {
        this.baseUri = uri != null && !uri.toString().endsWith("/") ? uri.resolve("/") : uri;
    }

    public String getConid() {
        return this.conid;
    }

    public void setAuthToken(AuthToken authToken) {
        this.authToken = authToken;
    }

    private static JSONObject getEnvData(URI baseUrl, AuthToken auth) throws JSONException, IOException {
        URI envUrl = baseUrl.resolve("api/v1/environment");
        String envResponse = null;
        try {
            envResponse = HttpUtil.get((URI)envUrl, (AuthToken)auth).response;
        }
        catch (IOException e) {
            Logger.logWarning("Error contacting Environment endpoint", e);
            throw e;
        }
        return new JSONObject(envResponse);
    }

    public static String getVersion(URI baseURI, AuthToken auth) {
        try {
            ConnectionEnv env = new ConnectionEnv(CodewindConnection.getEnvData(baseURI, auth));
            return env.getVersion();
        }
        catch (Exception e) {
            Logger.logWarning("An error occurred trying to get the Codewind version.", e);
            return null;
        }
    }

    public static int compareVersions(String versionA, String versionB) throws NumberFormatException {
        int i;
        if (versionA.equals(versionB)) {
            return 0;
        }
        if ("latest".equals(versionA) || "unknown".equals(versionB)) {
            return 1;
        }
        if ("latest".equals(versionB) || "unknown".equals(versionA)) {
            return -1;
        }
        String[] digitsA = versionA.split("\\.");
        String[] digitsB = versionB.split("\\.");
        for (i = 0; i < digitsA.length; ++i) {
            int valueA = Integer.parseInt(digitsA[i]);
            if (i >= digitsB.length) {
                if (valueA == 0) continue;
                return 1;
            }
            int valueB = Integer.parseInt(digitsB[i]);
            if (valueA > valueB) {
                return 1;
            }
            if (valueA >= valueB) continue;
            return -1;
        }
        if (digitsB.length > digitsA.length) {
            for (i = digitsA.length; i < digitsB.length; ++i) {
                int valueB = Integer.parseInt(digitsB[i]);
                if (valueB == 0) continue;
                return -1;
            }
        }
        return 0;
    }

    public static boolean isSupportedVersion(String versionStr) {
        if (!RELEASE_PATTERN.matcher(versionStr).matches()) {
            return true;
        }
        try {
            return CodewindConnection.compareVersions(versionStr, InstallUtil.getVersion()) >= 0;
        }
        catch (NumberFormatException e) {
            Logger.logWarning("Invalid version: " + versionStr, e);
            return false;
        }
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    public void refreshApps(String projectID) {
        URI projectsURL = this.baseUri.resolve("api/v1/projects");
        try {
            String projectsResponse = HttpUtil.get((URI)projectsURL, (AuthToken)this.authToken).response;
            CodewindApplicationFactory.getAppsFromProjectsJson(this, projectsResponse, projectID);
            Logger.log("App list update success");
        }
        catch (Exception e) {
            CoreUtil.openDialog(true, CodewindCoreBundle.message("Connection_ErrGettingProjectListTitle", new Object[0]), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(CodewindApplication app) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.put(app.projectID, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodewindApplication> getApps() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new ArrayList<CodewindApplication>(this.appMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAppIds() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new HashSet<String>(this.appMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(String projectID) {
        CodewindApplication app = null;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            app = this.appMap.remove(projectID);
        }
        if (app == null) {
            Logger.log("No application found for deleted project: " + projectID);
            return;
        }
        Logger.log("Removing the " + app.name + " application with id: " + projectID);
        CoreUtil.removeApplication(app);
        app.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByID(String projectID) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return this.appMap.get(projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByName(String name) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!app.name.equals(name)) continue;
                return app;
            }
        }
        Logger.log("No application found for name " + name);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByLocation(String location) {
        if (location == null) {
            return null;
        }
        String canonicalLocation = FileUtil.getCanonicalPath(location);
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!FileUtil.getCanonicalPath(app.fullLocalPath.toString()).equals(canonicalLocation)) continue;
                return app;
            }
        }
        Logger.log("No application found for location: " + location);
        return null;
    }

    public boolean waitForReady() throws IOException {
        IOException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.requestCodewindReady(500, 500)) {
                    return true;
                }
                Thread.sleep(500L);
                continue;
            }
            catch (IOException e) {
                exception = e;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
        return false;
    }

    public boolean requestCodewindReady(int connectTimeoutMS, int readTimeoutMS) throws IOException {
        String endpoint = "ready";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken, connectTimeoutMS, readTimeoutMS);
        this.checkResult(result, uri, true);
        return "true".equals(result.response);
    }

    public void requestProjectRestart(CodewindApplication app, String launchMode) throws JSONException, IOException {
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + "restart";
        URI url = this.baseUri.resolve(restartEndpoint);
        JSONObject restartProjectPayload = new JSONObject();
        restartProjectPayload.put("startMode", (Object)launchMode);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.authToken, restartProjectPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        app.invalidatePorts();
    }

    public void requestProjectOpenClose(CodewindApplication app, boolean enable) throws JSONException, IOException {
        String action = enable ? "open" : "close";
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + action;
        URI url = this.baseUri.resolve(restartEndpoint);
        HttpUtil.HttpResult result = HttpUtil.put(url, this.authToken);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public JSONObject requestProjectStatus(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl, this.authToken);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but null response when getting initial state");
        }
        JSONArray allProjectStatuses = new JSONArray(result.response);
        for (int i = 0; i < allProjectStatuses.length(); ++i) {
            JSONObject projectStatus = allProjectStatuses.getJSONObject(i);
            if (!projectStatus.getString("projectID").equals(app.projectID)) continue;
            return projectStatus;
        }
        Logger.log("Didn't find status info for project " + app.name);
        return null;
    }

    public JSONObject requestProjectMetricsStatus(CodewindApplication app) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "metrics/status";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        return new JSONObject(result.response);
    }

    public void requestProjectBuild(CodewindApplication app, String action) throws JSONException, IOException {
        String buildEndpoint = "api/v1/projects/" + app.projectID + "/" + "build";
        URI url = this.baseUri.resolve(buildEndpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("action", (Object)action);
        HttpUtil.post(url, this.authToken, buildPayload);
    }

    public List<ProjectLogInfo> requestProjectLogs(CodewindApplication app) throws JSONException, IOException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        JSONObject logs = new JSONObject(result.response);
        JSONArray buildLogs = logs.getJSONArray("build");
        logList.addAll(CodewindConnection.getLogs(buildLogs, "build"));
        JSONArray appLogs = logs.getJSONArray("app");
        logList.addAll(CodewindConnection.getLogs(appLogs, "app"));
        return logList;
    }

    public static List<ProjectLogInfo> getLogs(JSONArray logs, String type) throws JSONException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        if (logs != null) {
            for (int i = 0; i < logs.length(); ++i) {
                JSONObject log = logs.getJSONObject(i);
                if (log.has("logName")) {
                    String logName = log.getString("logName");
                    if ("-".equals(logName)) continue;
                    String workspacePath = null;
                    if (log.has("workspaceLogPath")) {
                        workspacePath = log.getString("workspaceLogPath");
                    }
                    ProjectLogInfo logInfo = new ProjectLogInfo(type, logName, workspacePath);
                    logList.add(logInfo);
                    continue;
                }
                Logger.log("An item in the log list does not have the key: logName");
            }
        }
        return logList;
    }

    public void requestEnableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken);
        this.checkResult(result, uri, false);
    }

    public void requestDisableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.authToken);
        this.checkResult(result, uri, false);
    }

    public void requestValidate(CodewindApplication app) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "validate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("projectType", (Object)app.projectType.getId());
        HttpUtil.HttpResult result = HttpUtil.post(url, this.authToken, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public void requestValidateGenerate(CodewindApplication app) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "validate/generate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("projectType", (Object)app.projectType.getId());
        buildPayload.put("autoGenerate", true);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.authToken, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        this.requestValidate(app);
    }

    public JSONObject requestProjectCapabilities(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects/" + app.projectID + "/" + "capabilities");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl, this.authToken);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but empty content when getting project capabilities");
        }
        JSONObject capabilities = new JSONObject(result.response);
        return capabilities;
    }

    public void requestProjectUnbind(String projectID) throws IOException {
        String endpoint = "api/v1/projects/" + projectID + "/" + "unbind";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken);
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    public List<ProjectTypeInfo> requestProjectTypes() throws IOException, JSONException {
        ArrayList<ProjectTypeInfo> projectTypes = new ArrayList<ProjectTypeInfo>();
        URI uri = this.baseUri.resolve("api/v1/project-types");
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        JSONArray array = new JSONArray(result.response);
        for (int i = 0; i < array.length(); ++i) {
            projectTypes.add(new ProjectTypeInfo(array.getJSONObject(i)));
        }
        return projectTypes;
    }

    private void checkResult(HttpUtil.HttpResult result, URI uri, boolean checkContent) throws IOException {
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response code %d for uri %s with error message %s", result.responseCode, uri, result.error);
            throw new IOException(msg);
        }
        if (checkContent && result.response == null) {
            throw new IOException("Server returned good response code, but the content of the result is null for uri: " + uri);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConnectionError() {
        if (this.isConnected) {
            Logger.log("Connection to " + this.baseUri + " lost");
            this.isConnected = false;
            Map<String, CodewindApplication> map = this.appMap;
            synchronized (map) {
                this.appMap.clear();
            }
            CoreUtil.updateAll();
        }
    }

    public synchronized void clearConnectionError() {
        Logger.log("Connection to " + this.baseUri + " restored");
        try {
            String oldSocketNS = this.env.getSocketNamespace();
            this.env = new ConnectionEnv(CodewindConnection.getEnvData(this.baseUri, this.authToken));
            if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
                Logger.logWarning("The detected version of Codewind after reconnect is not supported: " + this.env.getVersion());
                this.connectionErrorMsg = CodewindCoreBundle.message("Connection_ErrConnection_OldVersion", this.env.getVersion(), InstallUtil.getVersion());
                CoreUtil.updateConnection(this);
                return;
            }
            String socketNS = this.env.getSocketNamespace();
            if (socketNS != null && !socketNS.equals(oldSocketNS) || oldSocketNS != null && !oldSocketNS.equals(socketNS)) {
                this.socket.close();
                this.socket = new CodewindSocket(this, this.authToken);
                if (!this.socket.blockUntilFirstConnection()) {
                    Logger.logWarning("Failed to create a new socket with updated URI: " + this.socket.socketUri);
                    this.connectionErrorMsg = null;
                    CoreUtil.updateAll();
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.logWarning("An exception occurred while trying to update the connection information", e);
            this.connectionErrorMsg = CodewindCoreBundle.message("Connection_ErrConnection_UpdateCacheException", new Object[0]);
            CoreUtil.updateAll();
            return;
        }
        this.connectionErrorMsg = null;
        this.isConnected = true;
        this.refreshApps(null);
        CoreUtil.updateAll();
    }

    public String toString() {
        return String.format("%s @ name=%s baseUrl=%s conid=%s", CodewindConnection.class.getSimpleName(), this.name, this.baseUri == null ? "unknown" : this.baseUri, this.conid == null ? "<none>" : this.conid);
    }

    public void requestProjectDelete(String projectId) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + projectId;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.authToken);
        this.checkResult(result, uri, false);
    }

    public ConnectionEnv.TektonDashboard getTektonDashboard() {
        return this.env.getTektonDashboard();
    }

    public URI getNewProjectURI() {
        return this.getProjectURI("new-project");
    }

    public URI getImportProjectURI() {
        return this.getProjectURI("import-project");
    }

    private URI getProjectURI(String projectQuery) {
        try {
            URI uri = this.baseUri;
            String query = projectQuery + "=" + "true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri;
        }
        catch (Exception e) {
            Logger.logWarning("Failed to get the project URI for the query: " + projectQuery, e);
            return null;
        }
    }

    public boolean isLocal() {
        return false;
    }

    public List<CodewindApplication> getSortedApps() {
        List<CodewindApplication> apps = this.getApps().stream().sorted(Comparator.comparing(CodewindApplication::getName)).collect(Collectors.toList());
        return apps;
    }

    public void setBaseUri(URI uri) {
        this.baseUri = uri;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CodewindConnection)) {
            return false;
        }
        CodewindConnection other = (CodewindConnection)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

