/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.monitoring.lib.CCoverageInfo;
import org.eclipse.comma.monitoring.lib.utils.StringBuilder2;

public class CState
implements Serializable {
    protected Set<String> activeStates;
    protected String activeState;
    protected String executionState;
    protected String snapshot;
    protected Map<String, Integer> clauseMap;
    protected Map<String, Integer> stateMap;

    public Set<String> getActiveStates() {
        return this.activeStates;
    }

    public String getActiveState() {
        return this.activeState;
    }

    public String getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(String state) {
        this.executionState = state;
    }

    public void setActiveState(String state) {
        this.activeState = state;
    }

    public String toString() {
        return "State Information: variable values and current machine states";
    }

    public void takeSnapshot() {
        this.snapshot = this.toString();
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    protected void incMapEntry(String key, Map<String, Integer> map) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key) + 1);
        } else {
            map.put(key, 1);
        }
    }

    public void clauseEnacted(String clause) {
        this.incMapEntry(clause, this.clauseMap);
    }

    public void stateEnacted(String state) {
        this.incMapEntry(state, this.stateMap);
    }

    public Map<String, Integer> getClauseMap() {
        return this.clauseMap;
    }

    public Map<String, Integer> getStateMap() {
        return this.stateMap;
    }

    protected void mapUnion(Map<String, Integer> m1, Map<String, Integer> m2) {
        for (String key : m2.keySet()) {
            m1.put(key, m1.containsKey(key) ? m1.get(key) + m2.get(key) : m2.get(key));
        }
    }

    public void union(CState state) {
        this.mapUnion(this.clauseMap, state.getClauseMap());
        this.mapUnion(this.stateMap, state.getStateMap());
    }

    public String coverageInfoToString() {
        StringBuilder2 builder = new StringBuilder2();
        for (String clause : this.clauseMap.keySet()) {
            builder.append("State " + clause + ": " + this.clauseMap.get(clause));
            builder.newLine();
        }
        builder.newLine();
        long transitionCoverage = Math.round((double)this.clauseMap.values().stream().filter(v -> v > 0).count() * 100.0 / (double)this.clauseMap.size());
        builder.append("Transition coverage: " + transitionCoverage + "%");
        builder.newLine();
        builder.newLine();
        for (String state : this.stateMap.keySet()) {
            builder.append("State " + state + ": " + this.stateMap.get(state));
            builder.newLine();
        }
        builder.newLine();
        long stateCoverage = Math.round((double)this.stateMap.values().stream().filter(v -> v > 0).count() * 100.0 / (double)this.stateMap.size());
        builder.append("State coverage: " + stateCoverage + "%");
        builder.newLine();
        builder.newLine();
        return builder.toString();
    }

    public CCoverageInfo getCoverageInfo() {
        CCoverageInfo result = new CCoverageInfo();
        LinkedHashMap<String, Integer> cm = new LinkedHashMap<String, Integer>();
        this.mapUnion(cm, this.clauseMap);
        LinkedHashMap<String, Integer> sm = new LinkedHashMap<String, Integer>();
        this.mapUnion(sm, this.stateMap);
        result.setStateCoverage(sm);
        result.setTransitionCoverage(cm);
        return result;
    }
}

