/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import java.net.URI;
import java.util.List;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.restadapter.NotificationWSClientGenerator;
import org.eclipse.comma.project.generatortasks.restadapter.RESTServiceConfig;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AdapterGenerator {
    private static final String ADAPTER_CLASS_NAME = "Adapter";

    public static void generate(Component component, List<RESTServiceConfig> restServices, CommaFileSystemAccess fsa) {
        fsa.generateFile(AdapterGenerator.adapterFileName(), AdapterGenerator.adapterContent(component, restServices));
        for (RESTServiceConfig service : restServices) {
            Port _get = service.ports.get(0);
            if (!(_get instanceof ProvidedPort)) continue;
            for (Port port : service.ports) {
                EList _notifications = port.getInterface().getNotifications();
                for (Notification n : _notifications) {
                    NotificationWSClientGenerator.generate(fsa, n, port.getName(), service.pathMappings);
                }
            }
        }
    }

    public static String adapterFileName() {
        return "Adapter.java";
    }

    public static CharSequence adapterContent(Component component, List<RESTServiceConfig> restServices) {
        try {
            boolean _not_1;
            StringConcatenation _builder_1;
            StringConcatenation _builder_12;
            boolean _not;
            StringConcatenation _xblockexpression = null;
            Functions.Function1 _function = it -> it instanceof ProvidedPort;
            Iterable providedPorts = IterableExtensions.filter((Iterable)component.getPorts(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> it instanceof RequiredPort;
            Iterable requiredPorts = IterableExtensions.filter((Iterable)component.getPorts(), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> {
                Port _get = it.ports.get(0);
                return _get instanceof ProvidedPort;
            };
            Iterable providedRestServices = IterableExtensions.filter(restServices, (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> {
                Port _get = it.ports.get(0);
                return _get instanceof RequiredPort;
            };
            Iterable requiredRestServices = IterableExtensions.filter(restServices, (Functions.Function1)_function_3);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("package org.eclipse.comma.restadapter;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("import java.io.BufferedReader;");
            _builder.newLine();
            _builder.append("import java.io.IOException;");
            _builder.newLine();
            _builder.append("import java.io.InputStreamReader;");
            _builder.newLine();
            _builder.append("import java.net.URI;");
            _builder.newLine();
            _builder.append("import java.net.URISyntaxException;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("import javax.ws.rs.client.Client;");
            _builder.newLine();
            _builder.append("import javax.ws.rs.client.ClientBuilder;");
            _builder.newLine();
            _builder.append("import javax.ws.rs.client.WebTarget;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;");
            _builder.newLine();
            _builder.append("import org.glassfish.jersey.server.ResourceConfig;");
            _builder.newLine();
            _builder.append("import org.glassfish.tyrus.client.ClientManager;");
            _builder.newLine();
            _builder.append("import org.glassfish.tyrus.server.Server;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("import com.google.gson.JsonObject;");
            _builder.newLine();
            _builder.append("import com.google.gson.JsonParser;");
            _builder.newLine();
            _builder.append("import com.sun.net.httpserver.HttpServer;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("import jakarta.websocket.DeploymentException;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("public class ");
            _builder.append(ADAPTER_CLASS_NAME);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            for (Port port : providedPorts) {
                _builder.append("    ");
                _builder.append("private ");
                String _name = port.getInterface().getName();
                _builder.append(_name, "    ");
                _builder.append("Worker ");
                String _name_1 = port.getName();
                _builder.append(_name_1, "    ");
                _builder.append("Worker;");
                _builder.newLineIfNotEmpty();
            }
            for (Port port_1 : requiredPorts) {
                _builder.append("    ");
                _builder.append("private ");
                String _name_2 = port_1.getInterface().getName();
                _builder.append(_name_2, "    ");
                _builder.append("Worker ");
                String _name_3 = port_1.getName();
                _builder.append(_name_3, "    ");
                _builder.append("Worker;");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("public ");
            _builder.append(ADAPTER_CLASS_NAME, "    ");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)requiredPorts);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append("        ");
                _builder.append("startRequiredPortServices();");
                _builder.newLine();
            }
            _builder.append("        ");
            _builder.append("connectWSClients();");
            _builder.newLine();
            _builder.append("        ");
            _builder.newLine();
            _builder.append("        ");
            int counter = 1;
            _builder.newLineIfNotEmpty();
            for (RESTServiceConfig service : providedRestServices) {
                _builder.append("        ");
                _builder.append("Client client");
                _builder.append((Object)counter, "        ");
                _builder.append(" = ClientBuilder.newClient();");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("WebTarget target");
                _builder.append((Object)counter, "        ");
                _builder.append(" = client");
                _builder.append((Object)counter, "        ");
                _builder.append(".target(\"");
                _builder.append(service.urlREST, "        ");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                Object _xblockexpression_1 = null;
                ++counter;
                StringConcatenation _builder_13 = new StringConcatenation();
                _xblockexpression_1 = _builder_13;
                _builder.append(_xblockexpression_1, "        ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("        ");
            _builder.newLine();
            _builder.append("        ");
            StringConcatenation _xblockexpression_2 = null;
            counter = 1;
            _xblockexpression_2 = _builder_12 = new StringConcatenation();
            _builder.append((Object)_xblockexpression_2, "        ");
            _builder.newLineIfNotEmpty();
            for (RESTServiceConfig service_1 : providedRestServices) {
                for (Port port_2 : service_1.ports) {
                    _builder.append("        ");
                    String _name_4 = port_2.getName();
                    _builder.append(_name_4, "        ");
                    _builder.append("Worker = new ");
                    String _name_5 = port_2.getInterface().getName();
                    _builder.append(_name_5, "        ");
                    _builder.append("Worker(target");
                    _builder.append((Object)counter, "        ");
                    _builder.append(", \"");
                    String _name_6 = port_2.getName();
                    _builder.append(_name_6, "        ");
                    _builder.append("\", \"c\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("        ");
                StringConcatenation _xblockexpression_3 = null;
                ++counter;
                _xblockexpression_3 = _builder_1 = new StringConcatenation();
                _builder.append((Object)_xblockexpression_3, "        ");
                _builder.newLineIfNotEmpty();
            }
            for (Port port_3 : requiredPorts) {
                _builder.append("        ");
                String _name_7 = port_3.getName();
                _builder.append(_name_7, "        ");
                _builder.append("Worker = new ");
                String _name_8 = port_3.getInterface().getName();
                _builder.append(_name_8, "        ");
                _builder.append("Worker();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("        ");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("new Thread(() -> {");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("try {");
            _builder.newLine();
            _builder.append("                ");
            _builder.append("readEventsFromConsole();");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("} catch (IOException e) {");
            _builder.newLine();
            _builder.append("                ");
            _builder.append("e.printStackTrace();");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("}).start();");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("outputAdapterConfirmation();");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("private void readEventsFromConsole() throws IOException {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("String line;");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("while((line = reader.readLine()) != null) {");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("JsonObject event = JsonParser.parseString(line).getAsJsonObject();");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("// every event is handled in a separate thread");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("new Thread(() -> executeEvent(event)).start(); ");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("private void executeEvent(JsonObject event) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("String port = event.get(\"port\").getAsString();");
            _builder.newLine();
            _builder.append("        ");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("// dispatch of each event to the corresponding ");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("// worker per port");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("switch(port) {");
            _builder.newLine();
            for (Port port_4 : providedPorts) {
                _builder.append("            ");
                _builder.append("case \"");
                String _name_9 = port_4.getName();
                _builder.append(_name_9, "            ");
                _builder.append("\":");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("    ");
                String _name_10 = port_4.getName();
                _builder.append(_name_10, "                ");
                _builder.append("Worker.executeEvent(event);");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("    ");
                _builder.append("break;");
                _builder.newLine();
            }
            for (Port port_5 : requiredPorts) {
                _builder.append("            ");
                _builder.append("case \"");
                String _name_11 = port_5.getName();
                _builder.append(_name_11, "            ");
                _builder.append("\":");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("    ");
                String _name_12 = port_5.getName();
                _builder.append(_name_12, "                ");
                _builder.append("Worker.executeEvent(event);");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("    ");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("        ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("private void outputAdapterConfirmation() {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("String jsonString = \"{\\\"kind\\\":\\\"Adapter\\\", \\\"type\\\":\\\"started\\\"}\";");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("System.out.println(jsonString);");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)requiredPorts);
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                StringConcatenation _builder_14;
                StringConcatenation _builder_15;
                StringConcatenation _builder_16;
                _builder.append("    ");
                _builder.append("private void startRequiredPortServices() {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                Object _xblockexpression_4 = null;
                counter = 1;
                _builder_1 = new StringConcatenation();
                _xblockexpression_4 = _builder_1;
                _builder.append(_xblockexpression_4, "        ");
                _builder.newLineIfNotEmpty();
                for (RESTServiceConfig service_2 : requiredRestServices) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("URI baseUri");
                    int _plusPlus = counter++;
                    _builder.append((Object)_plusPlus, "        ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("try {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                StringConcatenation _xblockexpression_5 = null;
                counter = 1;
                _xblockexpression_5 = _builder_16 = new StringConcatenation();
                _builder.append((Object)_xblockexpression_5, "            ");
                _builder.newLineIfNotEmpty();
                for (RESTServiceConfig service_3 : requiredRestServices) {
                    _builder.append("    ");
                    _builder.append("        ");
                    Object _xifexpression = null;
                    boolean _endsWith = service_3.restTask.getRestServerURL().endsWith("/");
                    if (_endsWith) {
                        _xifexpression = service_3.restTask.getRestServerURL();
                    } else {
                        String _restServerURL = service_3.restTask.getRestServerURL();
                        _xifexpression = String.valueOf(_restServerURL) + "/";
                    }
                    String restServer = _xifexpression;
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("        ");
                    _builder.append("baseUri");
                    _builder.append((Object)counter, "            ");
                    _builder.append(" = new URI(\"");
                    _builder.append(restServer, "            ");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("        ");
                    _builder.append("ResourceConfig config");
                    _builder.append((Object)counter, "            ");
                    _builder.append(" = new ResourceConfig(");
                    String _apiName = ProjectUtility.getApiName(service_3.restTask);
                    _builder.append(_apiName, "            ");
                    _builder.append("Api.class);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("        ");
                    _builder.append("HttpServer server");
                    _builder.append((Object)counter, "            ");
                    _builder.append(" = JdkHttpServerFactory.createHttpServer(baseUri");
                    _builder.append((Object)counter, "            ");
                    _builder.append(", config");
                    int _plusPlus_1 = counter++;
                    _builder.append((Object)_plusPlus_1, "            ");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("} catch (URISyntaxException e1) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("e1.printStackTrace();");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                StringConcatenation _xblockexpression_6 = null;
                counter = 1;
                _xblockexpression_6 = _builder_15 = new StringConcatenation();
                _builder.append((Object)_xblockexpression_6, "        ");
                _builder.newLineIfNotEmpty();
                for (RESTServiceConfig service_4 : requiredRestServices) {
                    _builder.append("    ");
                    _builder.append("    ");
                    String _asyncServerURL = service_4.restTask.getAsyncServerURL();
                    URI uri = new URI(_asyncServerURL);
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("Server wsServer");
                    _builder.append((Object)counter, "        ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("wsServer");
                    int _plusPlus_2 = counter++;
                    _builder.append((Object)_plusPlus_2, "        ");
                    _builder.append(" = new Server (\"");
                    String _host = uri.getHost();
                    _builder.append(_host, "        ");
                    _builder.append("\", ");
                    int _port = uri.getPort();
                    _builder.append((Object)_port, "        ");
                    _builder.append(", \"/\", null, ");
                    String _apiName_1 = ProjectUtility.getApiName(service_4.restTask);
                    _builder.append(_apiName_1, "        ");
                    _builder.append("WSServer.class);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("try {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                StringConcatenation _xblockexpression_7 = null;
                counter = 1;
                _xblockexpression_7 = _builder_14 = new StringConcatenation();
                _builder.append((Object)_xblockexpression_7, "            ");
                _builder.newLineIfNotEmpty();
                for (RESTServiceConfig service_5 : requiredRestServices) {
                    _builder.append("    ");
                    _builder.append("        ");
                    _builder.append("wsServer");
                    int _plusPlus_3 = counter++;
                    _builder.append((Object)_plusPlus_3, "            ");
                    _builder.append(".start();");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("} catch (DeploymentException e) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("e.printStackTrace();");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.newLine();
            }
            _builder.append("    ");
            _builder.append("private void connectWSClients() {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("new Thread(() -> {");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("// one client for each notification");
            _builder.newLine();
            _builder.append("            ");
            String _xblockexpression_8 = null;
            counter = 1;
            _xblockexpression_8 = "";
            _builder.append(_xblockexpression_8, "            ");
            _builder.newLineIfNotEmpty();
            for (RESTServiceConfig service_6 : providedRestServices) {
                for (Port port_6 : service_6.ports) {
                    EList _notifications = port_6.getInterface().getNotifications();
                    for (Notification notification : _notifications) {
                        _builder.append("            ");
                        _builder.append("ClientManager client");
                        int _plusPlus_4 = counter++;
                        _builder.append((Object)_plusPlus_4, "            ");
                        _builder.append(" = ClientManager.createClient();");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
            _builder.append("            ");
            String _xblockexpression_9 = null;
            counter = 1;
            _xblockexpression_9 = "";
            _builder.append(_xblockexpression_9, "            ");
            _builder.newLineIfNotEmpty();
            _builder.append("            ");
            _builder.append("try {");
            _builder.newLine();
            _builder.append("                ");
            _builder.append("URI uri;");
            _builder.newLine();
            for (RESTServiceConfig service_7 : providedRestServices) {
                _builder.append("                ");
                String uri_1 = service_7.urlWS;
                _builder.newLineIfNotEmpty();
                for (Port port_7 : service_7.ports) {
                    EList _notifications_1 = port_7.getInterface().getNotifications();
                    for (Notification notification_1 : _notifications_1) {
                        _builder.append("                ");
                        Path path = ProjectUtility.getPath(service_7.pathMappings, port_7.getInterface(), (InterfaceEvent)notification_1);
                        _builder.newLineIfNotEmpty();
                        _builder.append("                ");
                        _builder.append("uri = new URI(\"");
                        _builder.append(uri_1, "                ");
                        Functions.Function1 _function_4 = it -> it instanceof FixedSegment;
                        Iterable _filter = IterableExtensions.filter(path.getSegments(), (Functions.Function1)_function_4);
                        for (Segment segment : _filter) {
                            _builder.append("/");
                            String _name_13 = ((FixedSegment)segment).getName();
                            _builder.append(_name_13, "                ");
                        }
                        _builder.append("\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append("                ");
                        _builder.append("client");
                        int _plusPlus_5 = counter++;
                        _builder.append((Object)_plusPlus_5, "                ");
                        _builder.append(".connectToServer(");
                        String _name_14 = port_7.getInterface().getName();
                        _builder.append(_name_14, "                ");
                        _builder.append("WSClient");
                        String _name_15 = notification_1.getName();
                        _builder.append(_name_15, "                ");
                        _builder.append(".class, uri);");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
            _builder.append("            ");
            _builder.append("} catch (DeploymentException | URISyntaxException | IOException e) {");
            _builder.newLine();
            _builder.append("                ");
            _builder.append("e.printStackTrace();");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("}).start();");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("public static void main(String[] args) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("new ");
            _builder.append(ADAPTER_CLASS_NAME, "        ");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _xblockexpression = _builder;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

