/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.firefox;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.InitializeLaunchConfigurations;

public class FirefoxRunDABDebugDelegate
extends DSPLaunchDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.runFirefoxDebug";
    static final String PORT = "port";
    static final String REQUEST = "request";
    static final String PREFERENCES = "preferences";
    static final String TMP_DIRS = "tmpdirs";
    static final String TYPE = "type";
    static final String DETACHED = "detached";
    static final String FIREFOX_EXECUTABLE = "firefoxExecutable";
    static final String PROFILE_DIR = "profileDir";
    static final String CONFIGURATION = "configuration";
    static final String RELOAD_ON_CHANGE = "reloadOnChange";
    static final String ARGUMENTS = "args";
    static final String FILE = "file";
    public static final String WORKING_DIRECTORY = "";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String fileToDebug = configuration.getAttribute(FILE, WORKING_DIRECTORY).trim();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(REQUEST, "launch");
        param.put(FIREFOX_EXECUTABLE, FirefoxRunDABDebugDelegate.findFirefoxLocation());
        param.put(FILE, fileToDebug);
        param.put(PREFERENCES, "{}");
        param.put(TMP_DIRS, System.getProperty("java.io.tmpdir"));
        param.put(TYPE, "firefox");
        param.put(DETACHED, Boolean.FALSE);
        if (configuration.getAttribute(RELOAD_ON_CHANGE, false)) {
            String workspaceDir = configuration.getAttribute(WORKING_DIRECTORY, WORKING_DIRECTORY);
            param.put(RELOAD_ON_CHANGE, workspaceDir);
        }
        try {
            List<String> debugCmdArgs = Collections.singletonList(FirefoxRunDABDebugDelegate.findDebugAdapter().getAbsolutePath());
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(InitializeLaunchConfigurations.getNodeJsLocation(), debugCmdArgs);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
        }
        catch (IOException | URISyntaxException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(new Runnable((IStatus)errorStatus){
                private final /* synthetic */ IStatus val$errorStatus;
                {
                    this.val$errorStatus = iStatus;
                }

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)e.getMessage(), (IStatus)this.val$errorStatus);
                }
            });
        }
    }

    static File findDebugAdapter() throws IOException, URISyntaxException {
        URL fileURL = FileLocator.toFileURL((URL)FirefoxRunDABDebugDelegate.class.getResource("/language-servers/node_modules/firefox-debugadapter/adapter.bundle.js"));
        return new File(fileURL.toURI());
    }

    private static String findFirefoxLocation() {
        String res = InitializeLaunchConfigurations.which("firefox");
        if (res != null) {
            return null;
        }
        return "/path/to/firefox";
    }
}

