/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.InitializeLaunchConfigurations;

public class NodeRunDAPDebugDelegate
extends DSPLaunchDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug";
    static final String PROGRAM = "program";
    public static final String ARGUMENTS = "args";
    private static final String CWD = "cwd";
    private static final String ENV = "env";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String cwd;
        Map env;
        Object[] args;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PROGRAM, configuration.getAttribute(PROGRAM, "no program path defined"));
        String argsString = configuration.getAttribute(ARGUMENTS, "").trim();
        if (!argsString.isEmpty() && (args = Arrays.asList(argsString.split(" ")).stream().filter(s -> !s.trim().isEmpty()).toArray()).length > 0) {
            param.put(ARGUMENTS, args);
        }
        if (!(env = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.emptyMap())).isEmpty()) {
            JsonObject envJson = new JsonObject();
            env.forEach((key, value) -> envJson.addProperty(key, value));
            param.put(ENV, envJson);
        }
        if (!(cwd = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "").trim()).isEmpty()) {
            param.put(CWD, cwd);
        }
        param.put("sourceMaps", false);
        try {
            URL fileURL = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/language-servers/node_modules/node-debug2/out/src/nodeDebug.js"));
            File file = new File(fileURL.getPath());
            List<String> debugCmdArgs = Collections.singletonList(file.getAbsolutePath());
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(InitializeLaunchConfigurations.getNodeJsLocation(), debugCmdArgs);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
        }
        catch (IOException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)e.getMessage(), (IStatus)errorStatus);
        }
    }
}

