/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.codeactions.CodeActionCompletionProposal;
import org.eclipse.lsp4e.operations.codeactions.LSPCodeActionMarkerResolution;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.progress.ProgressInfoItem;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeActionQuickAssistProcessor
implements IQuickAssistProcessor {
    private List<LanguageServiceAccessor.LSPDocumentInfo> infos;
    private Range range;
    List<ICompletionProposal> proposals = Collections.synchronizedList(new ArrayList());
    private static final ICompletionProposal COMPUTING = new ICompletionProposal(){

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return Messages.computing;
        }

        public Image getImage() {
            return JFaceResources.getImage((String)(String.valueOf(ProgressInfoItem.class.getPackage().getName()) + ".PROGRESS_DEFAULT"));
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    };
    CompletionProposal[] NO_PROPOSALS = new CompletionProposal[0];

    public String getErrorMessage() {
        return "CodeActions not implemented on this Language Server";
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        if (this.infos == null || this.infos.isEmpty()) {
            this.infos = this.getLSPDocumentInfos();
            if (this.infos.isEmpty()) {
                return false;
            }
        }
        CodeActionParams params = this.prepareCodeActionParams(this.infos);
        List possibleProposals = Collections.synchronizedList(new ArrayList());
        List<CompletableFuture> futures = this.infos.stream().map(info -> info.getInitializedLanguageClient().thenComposeAsync(ls -> ls.getTextDocumentService().codeAction(params).thenAcceptAsync(actions -> actions.stream().filter(Objects::nonNull).forEach(possibleProposals::add)))).collect(Collectors.toList());
        CompletableFuture<Void> aggregateFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        try {
            aggregateFutures.get(200L, TimeUnit.MILLISECONDS);
            return !possibleProposals.isEmpty();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
            return false;
        }
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        if (this.infos == null || this.infos.isEmpty()) {
            this.infos = this.getLSPDocumentInfos();
            if (this.infos.isEmpty()) {
                return this.NO_PROPOSALS;
            }
        }
        CodeActionParams params = this.prepareCodeActionParams(this.infos);
        try {
            if (this.proposals.contains(COMPUTING) || this.proposals.isEmpty()) {
                this.proposals.clear();
                List<CompletableFuture> futures = this.infos.stream().map(info -> ((CompletableFuture)info.getInitializedLanguageClient().thenComposeAsync(ls -> ls.getTextDocumentService().codeAction(params).thenAcceptAsync(actions -> actions.stream().filter(Objects::nonNull).map(action -> new CodeActionCompletionProposal((Either<Command, CodeAction>)action, (LanguageServiceAccessor.LSPDocumentInfo)info)).forEach(this.proposals::add)))).whenCompleteAsync((a, b) -> this.refreshProposals(invocationContext))).collect(Collectors.toList());
                CompletableFuture<Void> aggregateFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
                aggregateFutures.get(200L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (TimeoutException e) {
            this.proposals.add(COMPUTING);
        }
        return this.proposals.toArray(new ICompletionProposal[this.proposals.size()]);
    }

    private List<LanguageServiceAccessor.LSPDocumentInfo> getLSPDocumentInfos() {
        ITextEditor editor = LSPEclipseUtils.getActiveTextEditor();
        if (editor != null) {
            ITextEditor textEditor = editor;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            if (document == null) {
                return Collections.emptyList();
            }
            this.infos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, LSPCodeActionMarkerResolution::providesCodeActions);
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            try {
                this.range = new Range(LSPEclipseUtils.toPosition(selection.getOffset(), document), LSPEclipseUtils.toPosition(selection.getOffset() + selection.getLength(), document));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return this.infos;
    }

    private void refreshProposals(IQuickAssistInvocationContext invocationContext) {
        invocationContext.getSourceViewer().getTextWidget().getDisplay().asyncExec(() -> invocationContext.getSourceViewer().getTextOperationTarget().doOperation(22));
    }

    private CodeActionParams prepareCodeActionParams(List<LanguageServiceAccessor.LSPDocumentInfo> infos) {
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(infos.get(0).getFileUri().toString()));
        params.setRange(this.range);
        params.setContext(context);
        return params;
    }
}

