/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege;

import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.FolderNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.IPrivilegesTreeViewerInput;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.LeafNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.Messages;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;

public class PrivilegesTreeViewerInput
implements IPrivilegesTreeViewerInput {
    protected FolderNode _root;
    protected FolderNode _granteeFolder;
    protected FolderNode _usersFolder;
    protected FolderNode _groupsFolder;
    protected FolderNode _rolesFolder;
    protected ISchemaObjectEditModel _model;
    protected boolean _supportRole = false;

    public PrivilegesTreeViewerInput(ISchemaObjectEditModel model) {
        this._model = model;
        this.generateInput();
    }

    public PrivilegesTreeViewerInput(ISchemaObjectEditModel model, boolean supportRole) {
        this._model = model;
        this._supportRole = supportRole;
        this.generateInput();
    }

    protected void generateInput() {
        this._root = new FolderNode("root");
        this._granteeFolder = new FolderNode(Messages.PrivilegesTreeViewerInput_grantee);
        this._root.addChild(this._granteeFolder);
        this._usersFolder = new FolderNode(Messages.PrivilegesTreeViewerInput_users);
        this._granteeFolder.addChild(this._usersFolder);
        this._groupsFolder = new FolderNode(Messages.PrivilegesTreeViewerInput_groups);
        this._granteeFolder.addChild(this._groupsFolder);
        if (this._supportRole) {
            this._rolesFolder = new FolderNode(Messages.PrivilegesTreeViewerInput_roles);
            this._granteeFolder.addChild(this._rolesFolder);
        }
        this.refresh();
    }

    public FolderNode getRoot() {
        return this._root;
    }

    public FolderNode getGranteeFolder() {
        return this._granteeFolder;
    }

    public FolderNode getGroupsFolder() {
        return this._groupsFolder;
    }

    public FolderNode getRolesFolder() {
        return this._rolesFolder;
    }

    public FolderNode getUsersFolder() {
        return this._usersFolder;
    }

    public void refresh() {
        this._usersFolder.getChildren().clear();
        this._groupsFolder.getChildren().clear();
        if (this._supportRole) {
            this._rolesFolder.getChildren().clear();
        }
        List authids = (List)this._model.getAdditionalSQLObjects().get("authids");
        for (AuthorizationIdentifier authid : authids) {
            if (authid instanceof Group || authid instanceof Role) continue;
            this._usersFolder.addChild(new LeafNode(authid.getName(), authid));
        }
        for (AuthorizationIdentifier authid : authids) {
            if (!(authid instanceof Group)) continue;
            this._groupsFolder.addChild(new LeafNode(authid.getName(), authid));
        }
        if (this._supportRole) {
            for (AuthorizationIdentifier authid : authids) {
                if (!(authid instanceof Role)) continue;
                this._rolesFolder.addChild(new LeafNode(authid.getName(), authid));
            }
        }
    }
}

