/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.List;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternUpdateSpecification;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.PatternUpdateComparisonViewer;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ValuesViewer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InstanceConformityDialog
extends MessageDialog {
    protected final TemplatePatternUpdateSpecification _data;
    protected PatternUpdateComparisonViewer _differencesViewer;
    protected FeaturesViewer _detailsViewer;
    protected ValuesViewer _referenceViewer;
    protected ValuesViewer _targetViewer;
    protected IStructuredSelection _selection;
    EMFDiffNode _diffNode;
    EMatch _selectedMatch;
    private SashForm _sash;
    protected EditingDomain _editingDomain;

    public InstanceConformityDialog(Shell parentShell_p, String statusOverview_p, IPatternInstance instance_p, EObject referenceElement_p, List<EStructuralFeature> featuresToIgnore_p) {
        super(parentShell_p, Messages.InstanceConformityDialog_Header, null, String.valueOf(Messages.InstanceConformityDialog_Status) + statusOverview_p, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this._data = new TemplatePatternUpdateSpecification(instance_p, referenceElement_p, featuresToIgnore_p);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._editingDomain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(referenceElement_p);
        this._diffNode = new EMFDiffNode((GComparison)this._data.getVisualizationComparison(), this._editingDomain);
    }

    protected Control createCustomArea(Composite parent_p) {
        Group differencesGroup = new Group(parent_p, 4);
        differencesGroup.setText(this.getGroupName());
        GridData groupData = new GridData(4, 4, true, true);
        groupData.heightHint = 250;
        differencesGroup.setLayoutData((Object)groupData);
        GridLayout groupLayout = new GridLayout(1, false);
        differencesGroup.setLayout((Layout)groupLayout);
        this._sash = new SashForm((Composite)differencesGroup, 66048);
        this._sash.setLayout((Layout)new FillLayout());
        this._sash.setLayoutData((Object)new GridData(1808));
        this._differencesViewer = new PatternUpdateComparisonViewer((Composite)this._sash, this._editingDomain, false, false){

            @Override
            protected int getControlWidgetConfiguration() {
                return ModelSubsetViewer.SORT | ModelSubsetViewer.EXPAND | ModelSubsetViewer.COLLAPSE | ModelSubsetViewer.SHOW_PARENTS;
            }
        };
        this._differencesViewer.setInput(this.getData());
        this.createDetailsGroup((Composite)this._sash);
        this._sash.setWeights(new int[]{5, 3});
        return differencesGroup;
    }

    private void createDetailsGroup(Composite parent_p) {
        Group detailsGroup = new Group(parent_p, 4);
        detailsGroup.setText(Messages.InstanceConformityDialog_DetailsGroup);
        detailsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        detailsGroup.setLayout((Layout)new GridLayout(3, false));
        this.createCompositeArea((Composite)detailsGroup, Messages.InstanceConformityDialog_DetailsDifferenceGroup, 0);
        this.createCompositeArea((Composite)detailsGroup, Messages.InstanceConformityDialog_DetailsLeftGroup, 1);
        this.createCompositeArea((Composite)detailsGroup, Messages.InstanceConformityDialog_DetailsRightGroup, 2);
        this.createSynchronizationListener();
    }

    private Composite createCompositeArea(Composite parent_p, String message_p, int role_p) {
        Composite composite = this.createEmptyComposite(parent_p, 1);
        Label label = new Label(composite, 4);
        label.setText(message_p);
        if (role_p == 1) {
            this._targetViewer = new ValuesViewer(composite, true);
        } else if (role_p == 2) {
            this._referenceViewer = new ValuesViewer(composite, false);
        } else if (role_p == 0) {
            this.createDetailsFeatureViewer(composite);
        }
        return composite;
    }

    private void createDetailsFeatureViewer(Composite parent_p) {
        this._detailsViewer = new FeaturesViewer(parent_p);
        this._detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                Object obj;
                InstanceConformityDialog.this._targetViewer.setInput(null);
                InstanceConformityDialog.this._referenceViewer.setInput(null);
                ISelection detailSelection = InstanceConformityDialog.this._detailsViewer.getSelection();
                if (detailSelection != null && detailSelection instanceof StructuredSelection && !((StructuredSelection)detailSelection).isEmpty() && (obj = ((StructuredSelection)detailSelection).getFirstElement()) instanceof EStructuralFeature) {
                    MatchAndFeatureImpl maf = new MatchAndFeatureImpl((IMatch)InstanceConformityDialog.this._selectedMatch, obj, obj instanceof EAttribute);
                    ValuesViewer.ValuesInput targetInput = new ValuesViewer.ValuesInput(InstanceConformityDialog.this._diffNode, (MatchAndFeature)maf);
                    InstanceConformityDialog.this._targetViewer.setInput((Object)targetInput);
                    ValuesViewer.ValuesInput referenceInput = new ValuesViewer.ValuesInput(InstanceConformityDialog.this._diffNode, (MatchAndFeature)maf);
                    InstanceConformityDialog.this._referenceViewer.setInput((Object)referenceInput);
                }
            }
        });
    }

    protected void createSynchronizationListener() {
        this._differencesViewer.getTreeViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                EMatch match;
                InstanceConformityDialog.this._detailsViewer.setInput(null);
                InstanceConformityDialog.this._selection = InstanceConformityDialog.this._differencesViewer.getSelection();
                Object obj = InstanceConformityDialog.this._selection.getFirstElement();
                if (obj != null && obj instanceof EObject && (match = InstanceConformityDialog.this._data.getVisualizationComparison().getMapping().getMatchFor((Object)((EObject)obj), Role.TARGET)) instanceof EMatch) {
                    InstanceConformityDialog.this._selectedMatch = match;
                    FeaturesViewer.FeaturesInput input = new FeaturesViewer.FeaturesInput(InstanceConformityDialog.this._diffNode, (IMatch)InstanceConformityDialog.this._selectedMatch);
                    InstanceConformityDialog.this._detailsViewer.setInput((Object)input);
                    if (InstanceConformityDialog.this._detailsViewer.getElementAt(0) != null) {
                        InstanceConformityDialog.this._detailsViewer.setSelection((ISelection)new StructuredSelection(InstanceConformityDialog.this._detailsViewer.getElementAt(0)));
                    }
                }
            }
        });
    }

    private TemplatePatternUpdateSpecification getData() {
        return this._data;
    }

    private String getGroupName() {
        int nbDiffs = this.getData().getVisualizationComparison().getRemainingDifferences().size();
        return String.format(Messages.InstanceConformityDialog_Details, nbDiffs);
    }

    protected Composite createEmptyComposite(Composite parent_p, int columns_p) {
        Composite result = new Composite(parent_p, 2048);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(columns_p, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        return result;
    }
}

