/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternBasedBijection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.OclPatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter.OclInterpreter;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.interpreter.OCLExamplePlugin;
import org.eclipse.ocl.examples.interpreter.console.IOCLFactory;
import org.eclipse.ocl.examples.interpreter.console.ModelingLevel;
import org.eclipse.ocl.examples.interpreter.console.TargetMetamodel;
import org.eclipse.ocl.examples.interpreter.console.text.ColorManager;
import org.eclipse.ocl.examples.interpreter.console.text.OCLDocument;
import org.eclipse.ocl.examples.interpreter.console.text.OCLSourceViewer;
import org.eclipse.ocl.examples.interpreter.internal.l10n.OCLInterpreterMessages;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OclInputMessageDialog
extends MessageDialog {
    private Composite _composite;
    private ITextViewer _output;
    protected OCLSourceViewer _input;
    protected OCLDocument _document;
    private ColorManager _colorManager;
    private String _lastOCLExpression;
    private final boolean _mayConfirm;
    protected Object _context;
    protected final TemplatePatternRole _contextRole;
    protected final IPatternBasedBijection _valueMapping;
    protected IItemLabelProvider _tupleTypeLabelProvider = new TupleTypeItemLabelProvider();
    private static final AdapterFactory _reflectiveAdapterFactory = new ReflectiveItemProviderAdapterFactory();

    public OclInputMessageDialog(Shell parentShell_p, String dialogTitle_p, String dialogMessage_p, EObject context_p, TemplatePatternRole role_p, IPatternBasedBijection mapping_p, String initialBody_p, boolean mayConfirm_p) {
        super(parentShell_p, dialogTitle_p, null, dialogMessage_p, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._context = context_p != null ? context_p : new Object();
        this._lastOCLExpression = initialBody_p != null ? initialBody_p : "";
        this._contextRole = role_p;
        this._valueMapping = mapping_p;
        this._mayConfirm = mayConfirm_p;
    }

    protected Control createContents(Composite parent_p) {
        Control result = super.createContents(parent_p);
        this.getFinishButton().setEnabled(false);
        return result;
    }

    public Control createCustomArea(Composite parent) {
        this._composite = new SashForm(parent, 0x2000200);
        this._output = new TextViewer(this._composite, 2818);
        this._output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this._output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this._output.setEditable(false);
        this._output.setDocument((IDocument)new Document());
        this._colorManager = new ColorManager();
        this._document = new EcoreOclDocument();
        this._input = new OCLSourceViewer(this._composite, this._colorManager, 2050);
        this._input.setDocument((IDocument)this._document);
        this._input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.setContext(this._context);
        ((SashForm)this._composite).setWeights(new int[]{2, 1});
        GridData data = new GridData(1808);
        data.heightHint = 200;
        this._composite.setLayoutData((Object)data);
        this._document.set(this._lastOCLExpression);
        this._input.getTextWidget().setFocus();
        return this._composite;
    }

    public boolean close() {
        this._colorManager.dispose();
        return super.close();
    }

    protected void setContext(Object context_p) {
        this._context = context_p;
        if (this._context instanceof EObject) {
            this._document.setOCLContext((EObject)this._context);
        }
    }

    protected boolean evaluate(String rawExpression) {
        boolean result = true;
        if (this._context == null) {
            result = false;
            this.error(OCLInterpreterMessages.console_noContext);
        } else {
            try {
                IDocument doc = this.getDocument();
                Color outputDefault = this._colorManager.getColor(ColorManager.DEFAULT);
                Color outputResults = this._colorManager.getColor(ColorManager.OUTPUT_RESULTS);
                if (doc.getLength() > 0) {
                    this.append("", outputDefault, false);
                }
                this.print(OCLInterpreterMessages.console_evaluating, outputDefault, true);
                this.print(rawExpression, outputDefault, false);
                this.print(OCLInterpreterMessages.console_results, outputDefault, true);
                EObject context = this._context instanceof EObject ? (EObject)this._context : null;
                OCLExpression parsed = this.getInterpreter().parse(rawExpression, this._contextRole, context);
                Object evaluationResult = this.getInterpreter().evaluate(rawExpression, context, this._contextRole, this._valueMapping);
                this.print(evaluationResult, outputResults, false);
                this._lastOCLExpression = rawExpression;
                if (this._mayConfirm) {
                    this.getFinishButton().setEnabled(this.isValid(parsed, evaluationResult));
                }
            }
            catch (Exception e) {
                result = false;
                this.error(e.getLocalizedMessage());
                this.getFinishButton().setEnabled(false);
            }
        }
        return result;
    }

    private IDocument getDocument() {
        return this._output.getDocument();
    }

    public String getExpression() {
        return this._lastOCLExpression;
    }

    protected OclInterpreter getInterpreter() {
        return OclPatternsPlugin.getDefault().getInterpreter();
    }

    protected boolean isValid(OCLExpression parsedExpression_p, Object evaluationResult_p) {
        return true;
    }

    private void print(Object object, Color color, boolean bold) {
        Collection<Object> toPrint = object == null ? Collections.EMPTY_SET : (object instanceof Collection ? (Collection)object : (object.getClass().isArray() ? Arrays.asList((Object[])object) : Collections.singleton(object)));
        Iterator iter = toPrint.iterator();
        while (iter.hasNext()) {
            this.append(this.toString(iter.next()), color, bold);
        }
        this.scrollText();
    }

    protected String toString(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            IItemLabelProvider labeler = (IItemLabelProvider)EcoreUtil.getRegisteredAdapter((EObject)eObject, IItemLabelProvider.class);
            if (labeler == null) {
                labeler = eObject.eClass() instanceof TupleType ? this._tupleTypeLabelProvider : (IItemLabelProvider)_reflectiveAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            }
            if (labeler != null) {
                return labeler.getText(object);
            }
        }
        return String.valueOf(object);
    }

    private void error(String message_p) {
        this.append(message_p, this._colorManager.getColor(ColorManager.OUTPUT_ERROR), false);
        this.scrollText();
    }

    protected Button getFinishButton() {
        return this.getButton(0);
    }

    private void scrollText() {
        this._output.revealRange(this.getDocument().getLength(), 0);
    }

    private void append(String text_p, Color color_p, boolean bold_p) {
        String text = text_p;
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLength();
            int length = text.length();
            text = String.valueOf(text) + '\n';
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = color_p;
            if (bold_p) {
                style.fontStyle = 1;
            }
            this._output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, OCLExamplePlugin.getPluginId(), 1, OCLInterpreterMessages.console_outputExc, (Throwable)e);
            OCLExamplePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private class EcoreOCLFactory
    implements IOCLFactory<Object> {
        public TargetMetamodel getTargetMetamodel() {
            return TargetMetamodel.Ecore;
        }

        public Object getContextClassifier(EObject object) {
            return OclInputMessageDialog.this._context instanceof EObject ? ((EObject)OclInputMessageDialog.this._context).eClass() : null;
        }

        public String getName(Object modelElement) {
            return ((ENamedElement)modelElement).getName();
        }

        public <PK, O, P, EL, PM, S, COA, SSA, CT, CLS, E> org.eclipse.ocl.OCL<PK, Object, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createOCL(ModelingLevel level) {
            EObject context = OclInputMessageDialog.this._context instanceof EObject ? (EObject)OclInputMessageDialog.this._context : null;
            OCL result = OclInputMessageDialog.this.getInterpreter().createOCL(OclInputMessageDialog.this._contextRole, context);
            return result;
        }

        public <PK, O, P, EL, PM, S, COA, SSA, CT, CLS, E> org.eclipse.ocl.OCL<PK, Object, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createOCL(ModelingLevel level, Resource res) {
            EObject context = OclInputMessageDialog.this._context instanceof EObject ? (EObject)OclInputMessageDialog.this._context : null;
            OCL result = OclInputMessageDialog.this.getInterpreter().createOCL(OclInputMessageDialog.this._contextRole, context);
            return result;
        }
    }

    private class EcoreOclDocument
    extends OCLDocument {
        public EcoreOclDocument() {
            this.setOCLFactory(new EcoreOCLFactory());
            this.setModelingLevel(ModelingLevel.M2);
        }
    }

    private class InputKeyListener
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if (OclInputMessageDialog.this._input.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    String text = OclInputMessageDialog.this._document.get();
                    OclInputMessageDialog.this.evaluate(text);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 32: {
                    if ((e.stateMask & 0x40000) != 262144) break;
                    OclInputMessageDialog.this._input.getContentAssistant().showPossibleCompletions();
                }
            }
        }
    }

    private class TupleTypeItemLabelProvider
    implements IItemLabelProvider {
        public Object getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            Tuple tuple = (Tuple)object;
            TupleType tupleType = tuple.getTupleType();
            StringBuffer result = new StringBuffer();
            result.append("Tuple{");
            Iterator iter = tupleType.oclProperties().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                result.append(((ENamedElement)next).getName());
                result.append(" = ");
                result.append(OclInputMessageDialog.this.toString(tuple.getValue(next)));
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append('}');
            return result.toString();
        }
    }
}

