/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.emf.diffmerge.patterns.core.api.INamedElement;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamingUtil {
    private static final String NAMING_RULE_NEUTRAL = "$name$";
    private static final String NAMING_RULE_NEUTRAL_REGEX = Pattern.quote("$name$");
    private static final String INDEX_SYMBOL = "$nb$";
    private static final String INDEX_REGEX = Pattern.quote("$nb$");
    private static final String SUFFIX_SEP = "_";

    private NamingUtil() {
    }

    private static String appendIndexSuffix(String name_p, int index_p) {
        return String.valueOf(name_p) + SUFFIX_SEP + String.valueOf(index_p);
    }

    public static boolean applyRenamingRule(EObject element_p, String renamingRule_p) {
        boolean result = false;
        try {
            Object value;
            EAttribute nameAttribute = NamingUtil.getNameAttribute(element_p);
            if (nameAttribute != null && element_p.eIsSet((EStructuralFeature)nameAttribute) && (value = element_p.eGet((EStructuralFeature)nameAttribute)) != null) {
                String formerName = String.valueOf(value);
                String newName = NamingUtil.applyRenamingRule(formerName, renamingRule_p);
                element_p.eSet((EStructuralFeature)nameAttribute, (Object)newName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static EAttribute getNameAttribute(EObject element_p) {
        EAttribute result = null;
        if (element_p != null) {
            ISemanticRuleProvider provider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(element_p);
            result = provider.getNameAttribute(element_p);
        }
        return result;
    }

    public static boolean applyRenamingRule(EObject element_p, String renamingRule_p, boolean keepUserNames_p, String formerRenamingRule_p, String defaultName_p) {
        boolean result = true;
        try {
            Object value;
            EAttribute nameAttribute = NamingUtil.getNameAttribute(element_p);
            if (nameAttribute != null && element_p.eIsSet((EStructuralFeature)nameAttribute) && (value = element_p.eGet((EStructuralFeature)nameAttribute)) != null) {
                String formerName = String.valueOf(value);
                String coreName = null;
                if (defaultName_p != null && formerRenamingRule_p != null) {
                    String expectedFormerName = NamingUtil.applyRenamingRule(defaultName_p, formerRenamingRule_p);
                    if (!keepUserNames_p || formerName.equals(expectedFormerName)) {
                        coreName = defaultName_p;
                    }
                } else {
                    String suffix;
                    String prefix = NamingUtil.getPrefix(formerRenamingRule_p);
                    coreName = NamingUtil.unapplyRenamingRule(formerName, prefix, suffix = NamingUtil.getSuffix(formerRenamingRule_p));
                    if (coreName == null) {
                        coreName = defaultName_p;
                    }
                }
                if (coreName != null) {
                    String newName = NamingUtil.applyRenamingRule(coreName, renamingRule_p);
                    element_p.eSet((EStructuralFeature)nameAttribute, (Object)newName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String applyRenamingRule(String name_p, String renamingRule_p) {
        String result = renamingRule_p.replaceAll(NAMING_RULE_NEUTRAL_REGEX, name_p);
        return result;
    }

    public static String getIndexSymbol() {
        return INDEX_SYMBOL;
    }

    public static String getName(EObject element_p) {
        Object value;
        String result = null;
        EAttribute nameAttribute = NamingUtil.getNameAttribute(element_p);
        if (nameAttribute != null && element_p.eIsSet((EStructuralFeature)nameAttribute) && (value = element_p.eGet((EStructuralFeature)nameAttribute)) != null) {
            result = String.valueOf(value);
        }
        return result;
    }

    public static String getNeutralRenamingRule() {
        return NAMING_RULE_NEUTRAL;
    }

    private static String getPrefix(String namingRule_p) {
        int start;
        String result = null;
        if (namingRule_p != null && (start = namingRule_p.indexOf(NAMING_RULE_NEUTRAL)) > -1) {
            result = namingRule_p.substring(0, start);
        }
        return result;
    }

    private static String getSuffix(String namingRule_p) {
        int start;
        int suffixStart;
        String result = null;
        if (namingRule_p != null && (suffixStart = (start = namingRule_p.lastIndexOf(NAMING_RULE_NEUTRAL)) + NAMING_RULE_NEUTRAL.length()) < namingRule_p.length()) {
            result = namingRule_p.substring(suffixStart, namingRule_p.length());
        }
        return result;
    }

    public static String getSymbolicIndexedName() {
        return NAMING_RULE_NEUTRAL + NamingUtil.getSymbolicSuffix();
    }

    private static String getSymbolicSuffix() {
        return "_$nb$";
    }

    public static boolean haveUniqueNames(Collection<? extends INamedElement> elements_p) {
        HashSet<String> names = new HashSet<String>();
        for (INamedElement iNamedElement : elements_p) {
            if (iNamedElement.getName() == null) {
                return false;
            }
            names.add(iNamedElement.getName());
        }
        return names.size() == elements_p.size();
    }

    public static boolean isName(EStructuralFeature feature_p) {
        boolean result = false;
        if (feature_p instanceof EAttribute && feature_p.getName() != null) {
            result = "name".equals(feature_p.getName().toLowerCase()) && feature_p.getEType() == EcorePackage.eINSTANCE.getEString();
        }
        return result;
    }

    public static String proposeNamingRule(IPatternApplication application_p) {
        String result = null;
        if (application_p.getPattern() instanceof TemplatePattern) {
            TemplatePattern pattern = (TemplatePattern)application_p.getPattern();
            int suffixIndex = 0;
            for (TemplatePatternRole role : pattern.getRoles()) {
                ILocation location = application_p.getLocation((IPatternRole)role);
                if (location == null) continue;
                for (IAtomicLocation atomicLocation : location.getAtomicContents()) {
                    IReferenceLocation referenceLocation;
                    EObject container;
                    if (!(atomicLocation instanceof IReferenceLocation) || (container = (referenceLocation = (IReferenceLocation)atomicLocation).getElement()) == null) continue;
                    HashSet<String> siblingNames = new HashSet<String>();
                    for (EObject sibling : container.eContents()) {
                        String siblingName = NamingUtil.getName(sibling);
                        if (siblingName == null) continue;
                        siblingNames.add(siblingName);
                    }
                    for (EObject templateElement : role.getTemplateElements()) {
                        String name = NamingUtil.getName(templateElement);
                        if (name == null) continue;
                        String candidateName = suffixIndex == 0 ? name : NamingUtil.appendIndexSuffix(name, suffixIndex);
                        while (siblingNames.contains(candidateName)) {
                            candidateName = NamingUtil.appendIndexSuffix(name, ++suffixIndex);
                        }
                    }
                }
            }
            if (suffixIndex > 0) {
                result = NamingUtil.appendIndexSuffix(NamingUtil.getNeutralRenamingRule(), suffixIndex);
            }
        }
        return result;
    }

    public static String removeSymbolicIndexSuffix(String name_p) {
        String result = name_p.replaceAll(Pattern.quote(NamingUtil.getSymbolicSuffix()), "");
        return result;
    }

    public static boolean setName(EObject element_p, String name_p) {
        boolean result = false;
        EAttribute nameAttribute = NamingUtil.getNameAttribute(element_p);
        if (nameAttribute != null) {
            try {
                element_p.eSet((EStructuralFeature)nameAttribute, (Object)name_p);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String substituteIndex(String name_p, int index_p) {
        String replacement = String.valueOf(index_p);
        String result = name_p.replaceAll(INDEX_REGEX, replacement);
        return result;
    }

    private static String unapplyRenamingRule(String name_p, String prefix_p, String suffix_p) {
        String result = null;
        if (name_p != null && name_p.length() > 0) {
            boolean conforms = true;
            String current = name_p;
            if (prefix_p != null && prefix_p.length() > 0) {
                int originalSize = current.length();
                boolean bl = conforms = originalSize != (current = current.replaceFirst(Pattern.quote(prefix_p), "")).length();
            }
            if (conforms && suffix_p != null && suffix_p.length() > 0) {
                int start = current.lastIndexOf(suffix_p);
                if (start < 0 || name_p.length() > start + suffix_p.length()) {
                    conforms = false;
                } else {
                    current = current.substring(0, start);
                }
            }
            if (conforms) {
                result = current;
            }
        }
        return result;
    }
}

