/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.specifications;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.resources.PatternVirtualResource;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.TemplatePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePatternUpdateSpecification
extends AbstractModifiableTemplatePatternSpecification {
    private final IPatternInstance _instance;
    private final List<EStructuralFeature> _ignoredFeatures;
    private TemplatePatternApplicationComparison _visualizationComparison;

    public TemplatePatternUpdateSpecification(IPatternInstance instance_p, EObject referenceElement_p, List<EStructuralFeature> featuresToIgnore_p) {
        super(false, instance_p.getPattern() instanceof TemplatePattern && !((TemplatePattern)instance_p.getPattern()).getLayoutData().isEmpty(), TemplatePatternUpdateSpecification.getDefaultScopeElement(instance_p));
        this._instance = instance_p;
        this._ignoredFeatures = featuresToIgnore_p;
        TemplatePattern originalPattern = (TemplatePattern)instance_p.getPattern();
        EditingDomain originalPatternEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)originalPattern);
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        TemplatePattern copy = (TemplatePattern)copier.copy((EObject)originalPattern);
        copier.copyReferences();
        Resource vres = this.createVirtualResource(copier, originalPatternEditingDomain);
        vres.getContents().add((Object)copy);
        this.setPattern(copy);
        copy.setVersion(this.getNewVersion(copy));
        this.setRepository(originalPattern.getRepository());
        this.initializeComparison(instance_p, referenceElement_p);
    }

    private Resource createVirtualResource(EcoreUtil.Copier copier_p, EditingDomain originalPatternEditingDomain) {
        EditingDomain ed = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(null);
        if (ed == null) {
            ed = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack());
        } else if (ed instanceof TransactionalEditingDomain) {
            ed = null;
        }
        String resourceURI = "platform:/resource/Patterns/Temp.virtualpattern";
        PatternVirtualResource vres = new PatternVirtualResource((Map<EObject, EObject>)copier_p, originalPatternEditingDomain);
        vres.setURI(URI.createURI((String)resourceURI));
        if (ed != null) {
            ed.getResourceSet().getResources().add((Object)vres);
        }
        return vres;
    }

    @Override
    public Collection<EObject> getAllElements() {
        FOrderedSet result = new FOrderedSet();
        result.addAll(super.getAllElements());
        return result;
    }

    @Override
    public TemplatePatternApplicationComparison getComparison() {
        return (TemplatePatternApplicationComparison)super.getComparison();
    }

    private static EObject getDefaultScopeElement(IPatternInstance instance_p) {
        EObject result = null;
        List elements = instance_p.getElements();
        if (!elements.isEmpty()) {
            result = (EObject)elements.get(0);
        } else if (instance_p instanceof EObject) {
            result = (EObject)instance_p;
        } else if (instance_p.getScopeElement() instanceof EObject) {
            result = (EObject)instance_p.getScopeElement();
        }
        return result;
    }

    public List<EStructuralFeature> getIgnoredFeatures() {
        return this._ignoredFeatures;
    }

    public IPatternInstance getInstance() {
        return this._instance;
    }

    private String getMultipart(EObject referenceElement_p, IPatternInstance instance_p) {
        String result = null;
        String mainMultipart = TemplatePatternsPlugin.getDefault().getEngine().getMainMultipart();
        TemplatePatternData data = TemplatePatternsUtil.getPatternData((IPatternApplication)instance_p);
        if (data != null) {
            EList multiparts;
            if (referenceElement_p != null) {
                result = data.getMultipartOf(referenceElement_p);
            }
            if ((result == null || mainMultipart.equals(result)) && !(multiparts = data.getMultiparts()).isEmpty()) {
                result = (String)multiparts.iterator().next();
            }
        }
        if (result == null) {
            result = mainMultipart;
        }
        return result;
    }

    private String getNewVersion(TemplatePattern pattern_p) {
        String result = pattern_p.getVersion();
        String[] lines = result.split(VERSION_SEPARATOR_REGEX);
        if (lines.length > 0) {
            try {
                String suffix = lines[lines.length - 1];
                int suffixNb = Integer.parseInt(suffix);
                String newSuffix = String.valueOf(suffixNb + 1);
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < lines.length - 1) {
                    builder.append(lines[i]);
                    builder.append(".");
                    ++i;
                }
                builder.append(newSuffix);
                result = builder.toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public TemplatePattern getOriginalPattern() {
        return (TemplatePattern)this.getInstance().getPattern();
    }

    @Override
    protected Collection<IPatternInstance> getInstancesToIgnore() {
        Collection<IPatternInstance> result = super.getInstancesToIgnore();
        result.add(this._instance);
        return result;
    }

    public TemplatePatternApplicationComparison getVisualizationComparison() {
        return this._visualizationComparison;
    }

    private void initializeComparison(IPatternInstance instance_p, EObject referenceElement_p) {
        String multipart = this.getMultipart(referenceElement_p, instance_p);
        TemplatePatternApplicationScope applicationScope = new TemplatePatternApplicationScope((IPatternApplication)instance_p, multipart);
        EditingDomain originalPatternEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)instance_p.getPattern());
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject result = copier.copy((EObject)this.getPattern());
        copier.copyReferences();
        TemplatePattern patternCopy = (TemplatePattern)result;
        Resource vres = this.createVirtualResource(copier, originalPatternEditingDomain);
        vres.getContents().add((Object)patternCopy);
        this._visualizationComparison = new TemplatePatternApplicationComparison(patternCopy, applicationScope, this.getIgnoredFeatures());
        this._visualizationComparison.compute();
        TemplatePatternApplicationComparison comparison = new TemplatePatternApplicationComparison(this.getPattern(), applicationScope, this.getIgnoredFeatures());
        this.newComparison(comparison);
        comparison.compute();
        this.mergeDifferences();
        this.registerRoleElements();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && !this.getPattern().getVersion().equals(this.getOriginalPattern().getVersion());
    }

    @Override
    public void updateComparison() {
        this.getVisualizationComparison().update(null);
        super.updateComparison();
    }
}

