/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.TextCompareContent;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

public class TextMergerDialog
extends MessageDialog {
    protected static final int TOOLBAR_COLUMNS = 4;
    protected static final Point DEFAULT_SIZE = new Point(800, 600);
    protected static String __switchSidesActionLabel = null;
    protected final EMFDiffNode _diffNode;
    protected final IMatch _match;
    protected final EAttribute _feature;
    protected final ILabelProvider _labelProvider = DiffMergeLabelProvider.getInstance();
    protected TextMergeViewer _textViewer;
    protected ToolBarManager _toolBarManager;
    protected TextDiffNode _viewerInput;

    public TextMergerDialog(Shell shell_p, EMFDiffNode diffNode_p, IMatch match_p, EAttribute feature_p) {
        super(shell_p, null, null, null, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        assert (TextMergerDialog.isApplicableTo((EStructuralFeature)feature_p));
        this._diffNode = diffNode_p;
        this._match = match_p;
        this._feature = feature_p;
        this._toolBarManager = null;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this._textViewer.flush((IProgressMonitor)new NullProgressMonitor());
            this._viewerInput = (TextDiffNode)((Object)this._textViewer.getInput());
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.TextMergerDialog_ShellLabel);
        shell.setSize(DEFAULT_SIZE);
        super.configureShell(shell);
    }

    protected CompareConfiguration createCompareConfiguration() {
        CompareConfiguration result = new CompareConfiguration();
        result.setProperty("MIRRORED", (Object)Boolean.FALSE);
        if (this._diffNode.isThreeWay()) {
            result.setAncestorLabel(this._labelProvider.getText((Object)this.getScope(Role.ANCESTOR)));
        }
        result.setLeftLabel(this._labelProvider.getText((Object)this.getScope(true)));
        result.setLeftEditable(this._diffNode.isEditable(true));
        result.setRightLabel(this._labelProvider.getText((Object)this.getScope(false)));
        result.setRightEditable(this._diffNode.isEditable(false));
        return result;
    }

    protected Control createDialogArea(Composite parent_p) {
        GridLayout layout = new GridLayout();
        parent_p.setLayout((Layout)layout);
        Composite toolbar = new Composite(parent_p, 0);
        GridLayout toolbarLayout = new GridLayout(4, false);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbar.setLayout((Layout)toolbarLayout);
        toolbar.setLayoutData((Object)new GridData(4, 4, true, false));
        Label labelImage = new Label(toolbar, 0);
        labelImage.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
        labelImage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label labelText = new Label(toolbar, 128);
        labelText.setText(Messages.TextMergerDialog_HeaderLabel);
        labelText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite main = new Composite(parent_p, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 2;
        mainLayout.marginWidth = 0;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        CompareConfiguration cc = this.createCompareConfiguration();
        this._textViewer = this.createTextMergeViewer(main, toolbar, cc);
        this._textViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this._textViewer.getControl().setLayoutData((Object)data);
        TextDiffNode input = new TextDiffNode(this.getDifferencerKind());
        this._textViewer.setInput((Object)input);
        return main;
    }

    protected TextMergeViewer createTextMergeViewer(Composite parent_p, final Composite toolbar_p, CompareConfiguration cc_p) {
        TextMergeViewer result = new TextMergeViewer(parent_p, 2048, cc_p){

            protected IToolBarManager getToolBarManager(Composite localParent_p) {
                if (TextMergerDialog.this._toolBarManager != null && TextMergerDialog.this._toolBarManager.getControl() == null) {
                    return null;
                }
                if (TextMergerDialog.this._toolBarManager == null) {
                    TextMergerDialog.this._toolBarManager = TextMergerDialog.this.createToolBarManager(toolbar_p);
                }
                return TextMergerDialog.this._toolBarManager;
            }
        };
        return result;
    }

    protected ToolBarManager createToolBarManager(Composite parent_p) {
        ToolBar tb = new ToolBar(parent_p, 0x800000);
        tb.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        ToolBarManager result = new ToolBarManager(tb);
        result.setOverrides(new IContributionManagerOverrides(){

            public Integer getAccelerator(IContributionItem item_p) {
                return null;
            }

            public String getAcceleratorText(IContributionItem item_p) {
                return null;
            }

            public Boolean getEnabled(IContributionItem item_p) {
                Boolean localResult = null;
                if (TextMergerDialog.this.isSwitchSidesAction(item_p)) {
                    localResult = Boolean.FALSE;
                }
                return localResult;
            }

            public String getText(IContributionItem item_p) {
                return null;
            }

            public Boolean getVisible(IContributionItem item_p) {
                Boolean localResult = null;
                if (TextMergerDialog.this.isSwitchSidesAction(item_p)) {
                    localResult = Boolean.FALSE;
                }
                return localResult;
            }
        });
        return result;
    }

    protected IAttributeValuePresence getDifference() {
        IAttributeValuePresence result = null;
        Collection allDiffs = this._match.getAttributeDifferences(this._feature);
        if (!allDiffs.isEmpty()) {
            result = (IAttributeValuePresence)allDiffs.iterator().next();
        }
        return result;
    }

    protected int getDifferencerKind() {
        return this._diffNode.isThreeWay() ? 12 : 3;
    }

    protected IFeaturedModelScope getScope(boolean left_p) {
        return this.getScope(this._diffNode.getRoleForSide(left_p));
    }

    protected IFeaturedModelScope getScope(Role role_p) {
        return this._diffNode.getActualComparison().getScope(role_p);
    }

    protected String getSwitchSidesActionLabel() {
        String result = __switchSidesActionLabel;
        if (result == null) {
            String BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle("org.eclipse.compare.contentmergeviewer.TextMergeViewerResources");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (bundle != null) {
                String KEY = "action.SwitchLeftAndRight.label";
                result = bundle.getString("action.SwitchLeftAndRight.label");
            }
            __switchSidesActionLabel = result != null ? result : "FAILED_TO_COMPUTE_SWITCH_SIDES_ACTION_LABEL";
        }
        return result;
    }

    protected String getValue(Role role_p) {
        String result = null;
        IFeaturedModelScope scope = this.getScope(role_p);
        if (scope != null) {
            List rawValue;
            result = "";
            EObject element = this._match.get(role_p);
            if (element != null && (rawValue = scope.get(element, this._feature)).size() == 1) {
                result = (String)rawValue.get(0);
            }
        }
        return result;
    }

    public TextDiffNode getViewerInput() {
        return this._viewerInput;
    }

    public static boolean isApplicableTo(EStructuralFeature feature_p) {
        return feature_p instanceof EAttribute && feature_p.getUpperBound() == 1 && String.class.equals((Object)feature_p.getEType().getInstanceClass());
    }

    protected boolean isEditable(boolean left_p) {
        return !this._match.isPartial() && this._diffNode.isEditable(left_p) && !this._diffNode.isEditable(!left_p);
    }

    protected boolean isSwitchSidesAction(IContributionItem item_p) {
        ActionContributionItem actionItem;
        String itemLabel;
        boolean result = false;
        if (item_p instanceof ActionContributionItem && (itemLabel = (actionItem = (ActionContributionItem)item_p).getAction().getText()) != null) {
            result = itemLabel.equals(this.getSwitchSidesActionLabel());
        }
        return result;
    }

    protected class TextDiffNode
    extends DiffNode {
        private TextCompareContent _ancestorContent;
        private TextCompareContent _leftContent;
        private TextCompareContent _rightContent;

        public TextDiffNode(int kind_p) {
            super(kind_p);
        }

        public TextCompareContent getAncestor() {
            if (TextMergerDialog.this._diffNode.isThreeWay()) {
                this._ancestorContent = new TextCompareContent(TextMergerDialog.this.getValue(Role.ANCESTOR), false);
            }
            return this._ancestorContent;
        }

        public TextCompareContent getLeft() {
            if (this._leftContent == null) {
                this._leftContent = new TextCompareContent(TextMergerDialog.this.getValue(TextMergerDialog.this._diffNode.getRoleForSide(true)), TextMergerDialog.this.isEditable(true));
            }
            return this._leftContent;
        }

        public TextCompareContent getRight() {
            if (this._rightContent == null) {
                this._rightContent = new TextCompareContent(TextMergerDialog.this.getValue(TextMergerDialog.this._diffNode.getRoleForSide(false)), TextMergerDialog.this.isEditable(false));
            }
            return this._rightContent;
        }
    }
}

