/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.ecore.EObject;

public class ModelScopeIterator
implements TreeIterator<EObject> {
    private final IModelScope _scope;
    private final Iterator<EObject> _rootIterator;
    private TreeIterator<EObject> _rootContentIterator;
    private boolean _prunedOnRoot;
    private boolean _currentIsRoot;

    public ModelScopeIterator(IModelScope scope_p) {
        assert (scope_p != null);
        this._scope = scope_p;
        this._rootIterator = this._scope.getContents().iterator();
        this._prunedOnRoot = false;
        this._currentIsRoot = false;
    }

    public boolean hasNext() {
        return this.hasNextNonRoot() || this.hasNextRoot();
    }

    protected boolean hasNextNonRoot() {
        return !this._prunedOnRoot && this._rootContentIterator != null && this._rootContentIterator.hasNext();
    }

    protected boolean hasNextRoot() {
        return this._rootIterator.hasNext();
    }

    public EObject next() {
        EObject result = null;
        if (this.hasNextNonRoot()) {
            result = (EObject)this._rootContentIterator.next();
            this._currentIsRoot = false;
        } else if (this.hasNextRoot()) {
            result = this._rootIterator.next();
            this._rootContentIterator = this._scope.getAllContents(result);
            this._currentIsRoot = true;
        }
        this._prunedOnRoot = false;
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException();
    }

    public void prune() {
        if (this._currentIsRoot) {
            this._prunedOnRoot = true;
        } else if (this._rootContentIterator != null) {
            this._rootContentIterator.prune();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

