/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.console;

import java.io.IOException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Script;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.console.ScriptConsolePageParticipant;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.themes.IThemeManager;

public class ScriptConsole
extends IOConsole
implements IExecutionListener,
IScriptEngineProvider,
IPropertyChangeListener {
    private static final String TITLE_TERMINATED = " [terminated]";
    public static final String CONSOLE_ACTIVE = "ACTIVE";
    private IOConsoleOutputStream mOutputStream = null;
    private IOConsoleOutputStream mErrorStream = null;
    private IScriptEngine mEngine = null;
    private ILaunch mLaunch = null;
    private ScriptConsolePageParticipant mScriptConsolePageParticipant;

    public static ScriptConsole create(String title, IScriptEngine engine) {
        ScriptConsole console = new ScriptConsole(title, engine);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        return console;
    }

    public static ScriptConsole create(IScriptEngine engine) {
        return ScriptConsole.create(engine.getName(), engine);
    }

    private ScriptConsole(String name, IScriptEngine engine) {
        this(name, ScriptConsole.getConsoleType(), null, engine);
    }

    private ScriptConsole(String name, String consoleType, ImageDescriptor imageDescriptor, IScriptEngine engine) {
        super(name, consoleType, imageDescriptor, true);
        this.setScriptEngine(engine);
        this.initializeStreams();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void initializeStreams() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        IOConsoleOutputStream outputStream = this.getOutputStream();
        outputStream.setActivateOnWrite(store.getBoolean("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnOut"));
        IOConsoleOutputStream errorStream = this.getErrorStream();
        errorStream.setActivateOnWrite(store.getBoolean("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnErr"));
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ColorRegistry colorRegistry = themeManager.getCurrentTheme().getColorRegistry();
        errorStream.setColor(colorRegistry.get("ERROR_COLOR"));
    }

    public static String getConsoleType() {
        return "Text console type";
    }

    public IOConsoleOutputStream getErrorStream() {
        if (this.mErrorStream == null || this.mErrorStream.isClosed()) {
            this.mErrorStream = this.newOutputStream();
        }
        return this.mErrorStream;
    }

    public IOConsoleOutputStream getOutputStream() {
        if (this.mOutputStream == null || this.mOutputStream.isClosed()) {
            this.mOutputStream = this.newOutputStream();
        }
        return this.mOutputStream;
    }

    protected void dispose() {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.setScriptEngine(null);
        super.dispose();
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (engine.equals(this.getScriptEngine())) {
            switch (status) {
                case 2: {
                    this.terminate();
                }
            }
        }
    }

    public synchronized void terminate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScriptConsole.this.setName(String.valueOf(ScriptConsole.this.getName()) + ScriptConsole.TITLE_TERMINATED);
            }
        });
        this.setScriptEngine(null);
        this.closeStreams();
    }

    private void closeStreams() {
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.mErrorStream != null) {
                this.mErrorStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public IScriptEngine getScriptEngine() {
        return this.mEngine;
    }

    public void setLaunch(ILaunch launch) {
        this.mLaunch = launch;
    }

    public ILaunch getLaunch() {
        return this.mLaunch;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnOut")) {
            this.getOutputStream().setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
        } else if (property.equals("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnErr")) {
            this.getErrorStream().setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
        }
    }

    public synchronized void setScriptEngine(IScriptEngine scriptEngine) {
        if (scriptEngine == null || !scriptEngine.equals(this.mEngine)) {
            if (this.mEngine != null) {
                this.mEngine.removeExecutionListener((IExecutionListener)this);
                this.closeStreams();
            }
            this.mEngine = scriptEngine;
            if (this.mEngine != null) {
                this.mEngine.addExecutionListener((IExecutionListener)this);
            }
            if (this.mScriptConsolePageParticipant != null) {
                this.mScriptConsolePageParticipant.engineChanged();
            }
        }
    }

    public void setPageParticipant(ScriptConsolePageParticipant scriptConsolePageParticipant) {
        this.mScriptConsolePageParticipant = scriptConsolePageParticipant;
    }
}

