/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugElement;
import org.eclipse.ease.debugging.ScriptDebugStackFrame;
import org.eclipse.ease.debugging.ScriptDebugTarget;
import org.eclipse.ease.debugging.events.ResumeRequest;

public class ScriptDebugThread
extends ScriptDebugElement
implements IThread {
    private final Thread fThread;
    private ScriptDebugElement.State fState = ScriptDebugElement.State.NOT_STARTED;
    private List<ScriptDebugStackFrame> fStackFrames = new ArrayList<ScriptDebugStackFrame>();

    public ScriptDebugThread(ScriptDebugTarget target, Thread thread) {
        super(target);
        this.fThread = thread;
    }

    public String getName() throws DebugException {
        return "Thread: " + this.fThread.getName();
    }

    public synchronized IStackFrame[] getStackFrames() {
        return this.fStackFrames.toArray(new IStackFrame[this.fStackFrames.size()]);
    }

    public synchronized boolean hasStackFrames() {
        return this.getStackFrames().length > 0;
    }

    public synchronized ScriptDebugStackFrame getTopStackFrame() {
        if (this.hasStackFrames()) {
            return this.fStackFrames.get(0);
        }
        return null;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public Thread getThread() {
        return this.fThread;
    }

    public boolean isTerminated() {
        return ScriptDebugElement.State.TERMINATED == this.fState;
    }

    public boolean isSuspended() {
        return ScriptDebugElement.State.SUSPENDED == this.fState;
    }

    public boolean isStepping() {
        return ScriptDebugElement.State.STEPPING == this.fState;
    }

    protected void setTerminated() {
        this.fState = ScriptDebugElement.State.TERMINATED;
        this.fireTerminateEvent();
    }

    protected void setSuspended(int type) {
        this.fState = ScriptDebugElement.State.SUSPENDED;
        this.fireSuspendEvent(type);
    }

    protected void setResumed(int type) {
        this.fState = ScriptDebugElement.State.RESUMED;
        this.fireResumeEvent(type);
    }

    public synchronized void setStackFrames(List<IScriptDebugFrame> debugFrames) {
        ArrayList<ScriptDebugStackFrame> newStackFrames = new ArrayList<ScriptDebugStackFrame>(debugFrames.size());
        for (IScriptDebugFrame debugFrame : debugFrames) {
            ScriptDebugStackFrame stackFrame = null;
            for (ScriptDebugStackFrame oldStackFrame : this.fStackFrames) {
                if (!debugFrame.equals(oldStackFrame.getDebugFrame())) continue;
                stackFrame = oldStackFrame;
                stackFrame.setDirty();
                break;
            }
            if (stackFrame == null) {
                stackFrame = new ScriptDebugStackFrame(this, debugFrame);
            }
            newStackFrames.add(stackFrame);
        }
        this.fStackFrames = newStackFrames;
        this.fireChangeEvent(16);
    }

    @Override
    public boolean canStepInto() {
        return this.isSuspended();
    }

    @Override
    public boolean canStepOver() {
        return this.isSuspended();
    }

    @Override
    public boolean canStepReturn() {
        return this.isSuspended();
    }

    @Override
    public void stepInto() throws DebugException {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(1, this.getThread()));
    }

    @Override
    public void stepOver() throws DebugException {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(2, this.getThread()));
    }

    @Override
    public void stepReturn() throws DebugException {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(4, this.getThread()));
    }
}

