/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MainTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private boolean mDisableUpdate = false;
    private Text txtSourceFile;
    private Button chkSuspendOnScript;
    private Button chkShowDynamicScript;
    private Text fTxtStartupParameters;
    private ComboViewer comboViewer;
    private Button chkSuspendOnStartup;

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("File location", "");
        configuration.setAttribute("Script engine", "");
        configuration.setAttribute("Startup parameters", "");
        configuration.setAttribute("Suspend on startup", false);
        configuration.setAttribute("Suspend on script load", false);
        configuration.setAttribute("Display dynamic code", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.mDisableUpdate = true;
        this.txtSourceFile.setText("");
        this.chkShowDynamicScript.setSelection(false);
        this.chkSuspendOnStartup.setSelection(false);
        this.chkSuspendOnScript.setSelection(false);
        try {
            this.txtSourceFile.setText(configuration.getAttribute("File location", ""));
            this.populateScriptEngines();
            IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
            EngineDescription engineDescription = scriptService.getEngineByID(configuration.getAttribute("Script engine", ""));
            if (engineDescription != null) {
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)engineDescription));
            }
            this.fTxtStartupParameters.setText(configuration.getAttribute("Startup parameters", ""));
            this.chkShowDynamicScript.setSelection(configuration.getAttribute("Display dynamic code", false));
            this.chkSuspendOnStartup.setSelection(configuration.getAttribute("Suspend on startup", false));
            this.chkSuspendOnScript.setSelection(configuration.getAttribute("Suspend on script load", false));
            this.chkSuspendOnScript.setEnabled(this.chkSuspendOnStartup.getSelection());
        }
        catch (CoreException coreException) {}
        this.mDisableUpdate = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("File location", this.txtSourceFile.getText());
        IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
        if (!selection.isEmpty()) {
            EngineDescription engineDescription = (EngineDescription)selection.getFirstElement();
            configuration.setAttribute("Script engine", engineDescription.getID());
        }
        configuration.setAttribute("Startup parameters", this.fTxtStartupParameters.getText());
        configuration.setAttribute("Suspend on startup", this.chkSuspendOnStartup.getSelection());
        configuration.setAttribute("Suspend on script load", this.chkSuspendOnScript.getSelection() & this.chkSuspendOnStartup.getSelection());
        configuration.setAttribute("Display dynamic code", this.chkShowDynamicScript.getSelection());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            EngineDescription description;
            boolean resourceExists = ResourceTools.exists((String)launchConfig.getAttribute("File location", ""));
            if (!resourceExists) {
                this.setErrorMessage("Invalid source file selected.");
                return false;
            }
            String selectedEngineID = launchConfig.getAttribute("Script engine", "");
            IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
            Iterator iterator = scriptService.getEngines().iterator();
            do {
                if (iterator.hasNext()) continue;
                this.setErrorMessage("Invalid script engine selected.");
                return false;
            } while (!(description = (EngineDescription)iterator.next()).getID().equals(selectedEngineID));
            return true;
        }
        catch (CoreException coreException) {
            this.setErrorMessage("Invalid launch configuration detected.");
        }
        return false;
    }

    public boolean canSave() {
        return !this.txtSourceFile.getText().isEmpty() && !this.comboViewer.getSelection().isEmpty();
    }

    public String getMessage() {
        return "Please select a script file.";
    }

    public String getName() {
        return "Global";
    }

    public void createControl(final Composite parent) {
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)new GridLayout(1, false));
        Group grpScriptSource = new Group(topControl, 0);
        grpScriptSource.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpScriptSource.setText("Script Source");
        grpScriptSource.setLayout((Layout)new GridLayout(2, false));
        this.txtSourceFile = new Text((Composite)grpScriptSource, 2048);
        this.txtSourceFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.populateScriptEngines();
            }
        });
        this.txtSourceFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button btnBrowseProject = new Button((Composite)grpScriptSource, 0);
        btnBrowseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select script source file");
                dialog.setMessage("Select the script file to execute:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialog.open() == 0) {
                    MainTab.this.txtSourceFile.setText("workspace:/" + ((IFile)dialog.getFirstResult()).getFullPath().toPortableString());
                }
            }
        });
        btnBrowseProject.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        btnBrowseProject.setText("Browse Workspace...");
        Button btnBrowseFilesystem = new Button((Composite)grpScriptSource, 0);
        btnBrowseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MainTab.this.getShell(), 4096);
                String fileName = dialog.open();
                MainTab.this.txtSourceFile.setText(new File(fileName).toURI().toString());
            }
        });
        btnBrowseFilesystem.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnBrowseFilesystem.setText("Browse Filesystem...");
        Group grpExecutionEngine = new Group(topControl, 0);
        grpExecutionEngine.setLayout((Layout)new GridLayout(1, false));
        grpExecutionEngine.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpExecutionEngine.setText("Execution Engine");
        this.comboViewer = new ComboViewer((Composite)grpExecutionEngine, 0);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group grpProgramArguments = new Group(topControl, 0);
        grpProgramArguments.setLayout((Layout)new GridLayout(1, false));
        grpProgramArguments.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        grpProgramArguments.setText("Script arguments");
        this.fTxtStartupParameters = new Text((Composite)grpProgramArguments, 2114);
        this.fTxtStartupParameters.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fTxtStartupParameters.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group group = new Group(topControl, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        group.setText("Debug Options");
        this.chkShowDynamicScript = new Button((Composite)group, 32);
        this.chkShowDynamicScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MainTab.this.mDisableUpdate) {
                    MainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.chkShowDynamicScript.setText("Show dynamic script content");
        this.chkSuspendOnStartup = new Button((Composite)group, 32);
        this.chkSuspendOnStartup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.chkSuspendOnScript.setEnabled(MainTab.this.chkSuspendOnStartup.getSelection());
                if (!MainTab.this.mDisableUpdate) {
                    MainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.chkSuspendOnStartup.setText("Suspend on startup");
        this.chkSuspendOnScript = new Button((Composite)group, 32);
        GridData gd_chkSuspendOnScript = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_chkSuspendOnScript.horizontalIndent = 20;
        this.chkSuspendOnScript.setLayoutData((Object)gd_chkSuspendOnScript);
        this.chkSuspendOnScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MainTab.this.mDisableUpdate) {
                    MainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.chkSuspendOnScript.setText("Suspend on script load");
        this.setControl((Control)topControl);
    }

    protected void populateScriptEngines() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ScriptType scriptType = null;
        String sourceFile = this.txtSourceFile.getText();
        scriptType = scriptService.getScriptType(sourceFile);
        if (scriptType != null) {
            List engines = scriptService.getEngines(scriptType.getName());
            this.comboViewer.setInput((Object)engines);
            this.comboViewer.refresh();
            if (!engines.isEmpty()) {
                this.comboViewer.setSelection((ISelection)new StructuredSelection(engines.get(0)));
            }
        }
        this.updateLaunchConfigurationDialog();
    }
}

