/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.EventDispatchJob;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.events.BreakpointRequest;
import org.eclipse.ease.debugging.events.EngineStartedEvent;
import org.eclipse.ease.debugging.events.EngineTerminatedEvent;
import org.eclipse.ease.debugging.events.GetStackFramesRequest;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.ResumeRequest;
import org.eclipse.ease.debugging.events.ResumedEvent;
import org.eclipse.ease.debugging.events.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.StackFramesEvent;
import org.eclipse.ease.debugging.events.SuspendedEvent;

public abstract class AbstractScriptDebugger
implements IEventProcessor,
IExecutionListener {
    private EventDispatchJob fDispatcher;
    private IScriptEngine fEngine;
    private boolean fSuspended = false;
    private final Map<Script, List<IBreakpoint>> fBreakpoints = new HashMap<Script, List<IBreakpoint>>();
    private final boolean fShowDynamicCode;
    private int fResumeType;
    private List<IScriptDebugFrame> fStacktrace = new LinkedList<IScriptDebugFrame>();
    private int fResumeStackSize = 0;

    public AbstractScriptDebugger(IScriptEngine engine, boolean showDynamicCode) {
        this.fEngine = engine;
        this.fShowDynamicCode = showDynamicCode;
        this.fEngine.addExecutionListener(this);
    }

    public void setDispatcher(EventDispatchJob dispatcher) {
        this.fDispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDispatchEvent(IDebugEvent event) {
        EventDispatchJob eventDispatchJob = this.fDispatcher;
        synchronized (eventDispatchJob) {
            if (this.fDispatcher != null) {
                this.fDispatcher.addEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(IDebugEvent event) {
        IScriptEngine iScriptEngine = this.fEngine;
        synchronized (iScriptEngine) {
            this.fSuspended = true;
            this.fireDispatchEvent(event);
            try {
                while (this.fSuspended) {
                    this.fEngine.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.fSuspended = false;
            }
            this.fireDispatchEvent(new ResumedEvent(Thread.currentThread(), this.getResumeType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume(int resumeType) {
        if (resumeType != 0) {
            this.fResumeType = resumeType;
            this.fResumeStackSize = this.getStacktrace().size();
        }
        IScriptEngine iScriptEngine = this.fEngine;
        synchronized (iScriptEngine) {
            this.fSuspended = false;
            this.fEngine.notifyAll();
        }
    }

    protected IScriptEngine getEngine() {
        return this.fEngine;
    }

    @Override
    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 1: {
                this.fireDispatchEvent(new EngineStartedEvent());
                break;
            }
            case 2: {
                this.fireDispatchEvent(new EngineTerminatedEvent());
                this.fEngine.removeExecutionListener(this);
                this.fEngine = null;
                break;
            }
            case 3: 
            case 5: {
                if (!this.isTrackedScript(script)) break;
                this.suspend(new ScriptReadyEvent(script, Thread.currentThread(), this.fStacktrace.isEmpty()));
                break;
            }
            case 4: 
            case 6: {
                break;
            }
        }
    }

    @Override
    public void handleEvent(IDebugEvent event) {
        if (event instanceof ResumeRequest) {
            this.resume(((ResumeRequest)event).getType());
        } else if (event instanceof BreakpointRequest) {
            Script script = ((BreakpointRequest)event).getScript();
            if (!this.fBreakpoints.containsKey(script)) {
                this.fBreakpoints.put(script, new ArrayList());
            }
            if (((BreakpointRequest)event).getMode() == BreakpointRequest.Mode.ADD) {
                this.fBreakpoints.get(script).add(((BreakpointRequest)event).getBreakpoint());
            } else {
                this.fBreakpoints.get(script).remove(((BreakpointRequest)event).getBreakpoint());
            }
        } else if (event instanceof GetStackFramesRequest) {
            this.fireDispatchEvent(new StackFramesEvent(this.getStacktrace(), ((AbstractScriptEngine)this.fEngine).getThread()));
        }
    }

    protected IBreakpoint getBreakpoint(Script script, int lineNumber) {
        List<IBreakpoint> breakpoints = this.fBreakpoints.get(script);
        if (breakpoints != null) {
            for (IBreakpoint breakpoint : breakpoints) {
                try {
                    int breakLocation;
                    if (!breakpoint.isEnabled() || lineNumber != (breakLocation = breakpoint.getMarker().getAttribute("lineNumber", -1))) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    protected boolean isTrackedScript(Script script) {
        return !script.isDynamic() || this.fShowDynamicCode;
    }

    protected int getResumeType() {
        return this.fResumeType;
    }

    protected List<IScriptDebugFrame> getStacktrace() {
        return this.fStacktrace;
    }

    protected void setStacktrace(List<IScriptDebugFrame> stacktrace) {
        this.fStacktrace = stacktrace;
    }

    protected void processLine(Script script, int lineNumber) {
        IBreakpoint breakpoint = this.getBreakpoint(script, lineNumber);
        if (breakpoint != null) {
            this.suspend(new SuspendedEvent(16, ((AbstractScriptEngine)this.fEngine).getThread(), this.getStacktrace()));
            return;
        }
        switch (this.getResumeType()) {
            case 1: {
                if (this.fResumeStackSize > this.getStacktrace().size()) break;
                this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)this.fEngine).getThread(), this.getStacktrace()));
                break;
            }
            case 2: {
                if (this.fResumeStackSize < this.getStacktrace().size()) break;
                this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)this.fEngine).getThread(), this.getStacktrace()));
                break;
            }
            case 4: {
                if (this.fResumeStackSize <= this.getStacktrace().size()) break;
                this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)this.fEngine).getThread(), this.getStacktrace()));
            }
        }
    }
}

